/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.algorithms.commands.cache.events;

import csbase.client.util.event.IEvent;
import csbase.logic.CommandFinalizationType;
import csbase.logic.CommandInfo;

public class CommandUpdatedEvent
implements IEvent {
    private Type type;
    private Exception exception;
    private String exceptionDescription;
    private CommandInfo command;

    public CommandUpdatedEvent(Exception e, String description) {
        this.type = Type.exception;
        this.exception = e;
        this.exceptionDescription = description;
        this.command = null;
    }

    public CommandUpdatedEvent(CommandInfo command, Type type) {
        if (Type.exception.equals((Object)type)) {
            throw new IllegalArgumentException("Tipo de evento inv\u00e1lido. O tipo exception s\u00f3 deve ser utilizado quando for lan\u00e7ada uma exce\u00e7\u00e3o durante o processo de atualiza\u00e7\u00e3o dos comandos.");
        }
        this.command = command;
        this.type = type;
    }

    public Exception getException() {
        return this.exception;
    }

    public String getExceptionDescription() {
        return this.exceptionDescription;
    }

    public CommandInfo getCommand() {
        return this.command;
    }

    public Type getType() {
        return this.type;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.command == null ? 0 : this.command.hashCode());
        result = 31 * result + (this.exception == null ? 0 : this.exception.getClass().hashCode());
        result = 31 * result + (this.exceptionDescription == null ? 0 : this.exceptionDescription.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CommandUpdatedEvent other = (CommandUpdatedEvent)obj;
        if (this.command == null ? other.command != null : !this.command.equals((Object)other.command)) {
            return false;
        }
        if (this.exception == null ? other.exception != null : !this.exception.getClass().equals(other.exception.getClass())) {
            return false;
        }
        if (this.exceptionDescription == null ? other.exceptionDescription != null : !this.exceptionDescription.equals(other.exceptionDescription)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals((Object)other.type));
    }

    public static enum Type {
        exception,
        created,
        updated,
        system_failure,
        end,
        error,
        success,
        failed,
        killed,
        lost,
        removed,
        no_code;


        public static Type valueOf(CommandFinalizationType finalizationType) {
            switch (finalizationType) {
                case END: {
                    return end;
                }
                case SUCCESS: {
                    return success;
                }
                case EXECUTION_ERROR: {
                    return error;
                }
                case FAILED: {
                    return failed;
                }
                case KILLED: {
                    return killed;
                }
                case LOST: {
                    return lost;
                }
                case NO_EXIT_CODE: {
                    return no_code;
                }
                case NOT_FINISHED: {
                    return null;
                }
            }
            return end;
        }
    }
}

