/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.algorithms.parameters;

import csbase.client.algorithms.parameters.ParameterViewListener;
import csbase.client.algorithms.validation.ViewValidator;
import csbase.logic.algorithms.parameters.Parameter;
import java.util.LinkedList;
import java.util.List;

public abstract class ParameterView<T extends Parameter<?>>
implements ViewValidator {
    private List<ParameterViewListener> listeners;
    private T parameter;
    private final Mode mode;

    public ParameterView(T parameter, Mode mode) {
        this.mode = mode;
        this.listeners = new LinkedList<ParameterViewListener>();
        this.setParameter(parameter);
    }

    public final void addParameterViewListener(ParameterViewListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("O par\u00e2metro listener est\u00e1 nulo.");
        }
        this.listeners.add(listener);
    }

    protected abstract boolean isVisible();

    protected abstract void setVisible(boolean var1);

    protected void updateVisibilyView() {
        if (this.isVisible() != this.getParameter().isVisible()) {
            this.setVisible(this.getParameter().isVisible());
            this.fireVisibilityWasChanged();
        }
    }

    protected final void fireVisibilityWasChanged() {
        for (ParameterViewListener listener : this.listeners) {
            listener.visibilityWasChanged(this);
        }
    }

    public abstract boolean fillVerticalSpace();

    public final String toString() {
        return this.getParameter().toString();
    }

    public T getParameter() {
        return this.parameter;
    }

    private void setParameter(T parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException("O par\u00e2metro parameter est\u00e1 nulo.");
        }
        this.parameter = parameter;
    }

    public Mode getMode() {
        return this.mode;
    }

    public static enum Mode {
        CONFIGURATION,
        REPORT;

    }
}

