/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applicationmanager;

import csbase.client.applicationmanager.ApplicationManager;
import csbase.logic.applicationservice.ApplicationRegistry;
import java.awt.event.ActionEvent;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;

public final class ApplicationStartAction
extends AbstractAction {
    private final ApplicationRegistry registry;

    public final ApplicationRegistry getApplicationRegistry() {
        return this.registry;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (!this.isEnabled()) {
            String err = "Action perform called and it is inactive!";
            throw new RuntimeException("Action perform called and it is inactive!");
        }
        ApplicationManager appManager = ApplicationManager.getInstance();
        try {
            appManager.runApplication(this.registry.getId());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    ApplicationStartAction(ApplicationRegistry registry, Locale locale) {
        this.registry = registry;
        String appName = registry.getApplicationName(locale);
        this.putValue("Name", appName);
        byte[] iconDefinition = registry.getIconDefinition();
        if (iconDefinition != null) {
            this.putValue("SmallIcon", new ImageIcon(iconDefinition));
        }
    }
}

