/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.actions;

import csbase.client.applications.algorithmsmanager.AlgorithmsManager;
import csbase.client.applications.algorithmsmanager.actions.CommonEditAction;
import csbase.client.applications.algorithmsmanager.dialogs.CommonSelectionPanel;
import csbase.client.applications.algorithmsmanager.models.AlgorithmListItem;
import csbase.client.applications.algorithmsmanager.models.DataInterface;
import csbase.client.remote.srvproxies.AlgorithmManagementProxy;
import csbase.logic.algorithms.AlgorithmInfo;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;

public class AlgorithmRemoveAction
extends CommonEditAction {
    public AlgorithmRemoveAction(CommonSelectionPanel selectionPanel, ImageIcon icon) {
        super(selectionPanel, icon);
    }

    private int removeAlgorithms(List<AlgorithmInfo> algorithms) {
        int removedCounter = 0;
        for (AlgorithmInfo algoInfo : algorithms) {
            boolean removed = AlgorithmManagementProxy.removeAlgorithm(algoInfo.getId(), ((AlgorithmsManager)this.getApplication()).getApplicationFrame());
            if (!removed) continue;
            ++removedCounter;
        }
        return removedCounter;
    }

    @Override
    protected void handleEditOperation() {
        int removedCounter;
        List<DataInterface> algorithmItems = this.getSelectionPanel().getSelectedDataList();
        if (algorithmItems == null || algorithmItems.isEmpty()) {
            return;
        }
        int option = ((AlgorithmsManager)this.getApplication()).showOptionDialog(this.getString("AlgorithmRemoveAction.msg.cancel.confirm", new Object[0]), new String[]{this.getString("AlgorithmRemoveAction.msg.cancel.confirm.yes", new Object[0]), this.getString("AlgorithmRemoveAction.msg.cancel.confirm.no", new Object[0])});
        if (option == 0 && (removedCounter = this.removeAlgorithms(this.getAlgorithms(algorithmItems))) != algorithmItems.size()) {
            String msg = MessageFormat.format(this.getString("AlgorithmRemoveAction.msg.error.remove.no_sucess", new Object[0]), removedCounter);
            ((AlgorithmsManager)this.getApplication()).showMessage(msg);
        }
    }

    private List<AlgorithmInfo> getAlgorithms(List<DataInterface> algorithmItemList) {
        ArrayList<AlgorithmInfo> algoList = new ArrayList<AlgorithmInfo>();
        for (DataInterface item : algorithmItemList) {
            AlgorithmListItem algoItem = (AlgorithmListItem)item;
            algoList.add(algoItem.getItem());
        }
        return algoList;
    }
}

