/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.actions;

import csbase.client.applications.algorithmsmanager.AlgorithmsManager;
import csbase.client.applications.algorithmsmanager.actions.AlgorithmsManagerAction;
import csbase.client.applications.algorithmsmanager.dialogs.AlgorithmVersionInfoPanel;
import csbase.client.remote.srvproxies.AlgorithmManagementProxy;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.ImageIcon;
import tecgraf.javautils.gui.StandardDialogs;

public class VersionRemoveAction
extends AlgorithmsManagerAction {
    private AlgorithmVersionInfoPanel versionInfoPanel;

    public VersionRemoveAction(AlgorithmVersionInfoPanel versionInfoPanel, ImageIcon icon) {
        super((AlgorithmsManager)versionInfoPanel.getApplication(), icon);
        this.versionInfoPanel = versionInfoPanel;
        this.setEnabled(false);
    }

    @Override
    protected void handleActionPerformed(ActionEvent ae) throws Exception {
        List<AlgorithmVersionInfo> versions = this.versionInfoPanel.getSelectedVersions();
        if (this.confirmRemove(versions)) {
            for (AlgorithmVersionInfo i : versions) {
                AlgorithmInfo info = i.getInfo();
                AlgorithmManagementProxy.removeVersion(info.getId(), i.getId(), ((AlgorithmsManager)this.getApplication()).getApplicationFrame());
            }
        }
    }

    private boolean confirmRemove(List<AlgorithmVersionInfo> versions) {
        int opt = -1;
        Object[] options = new Object[]{this.getString("VersionRemoveAction.button.remove", new Object[0]), this.getString("VersionRemoveAction.button.cancel", new Object[0])};
        if (versions.size() == 1) {
            String dialogTitle = this.getString("VersionRemoveAction.title.remove.version", new Object[0]);
            AlgorithmVersionInfo algoVersion = versions.get(0);
            opt = StandardDialogs.showOptionDialog((Component)((AlgorithmsManager)this.getApplication()).getApplicationFrame(), (String)dialogTitle, (Object)this.getClassString("confirm.remove.version", algoVersion.getId()), (Object[])options);
        } else {
            String dialogTitle = this.getString("VersionRemoveAction.title.remove.versions", new Object[0]);
            opt = StandardDialogs.showOptionDialog((Component)((AlgorithmsManager)this.getApplication()).getApplicationFrame(), (String)dialogTitle, (Object)this.getString("VersionRemoveAction.confirm.remove.versions", new Object[0]), (Object[])options);
        }
        return opt == 0;
    }
}

