/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.commandsmonitor;

import csbase.client.algorithms.commands.cache.CommandsCache;
import csbase.client.algorithms.commands.cache.events.FinishedOrSystemFailureCommandsLoadingEvent;
import csbase.client.applicationmanager.ApplicationException;
import csbase.client.applications.Application;
import csbase.client.applications.ApplicationExitAction;
import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.commandsmonitor.TablesPanel;
import csbase.client.applications.commandsmonitor.TablesTabbedPane;
import csbase.client.applications.commandsmonitor.actions.ExecuteCommandAction;
import csbase.client.applications.commandsmonitor.actions.KillCommandsAction;
import csbase.client.applications.commandsmonitor.actions.RefreshCommandsAction;
import csbase.client.applications.commandsmonitor.actions.RemoveCommandsAction;
import csbase.client.applications.commandsmonitor.actions.SchedulerSwitchAction;
import csbase.client.applications.commandsmonitor.actions.ShowCommandDetailsAction;
import csbase.client.applications.commandsmonitor.actions.ShowCommandDirAction;
import csbase.client.applications.commandsmonitor.actions.ShowCommandLogAction;
import csbase.client.applications.commandsmonitor.actions.ShowCommandParametersAction;
import csbase.client.applications.commandsmonitor.dal.xml.XmlConfigDAO;
import csbase.client.applications.commandsmonitor.events.DoubleClickEvent;
import csbase.client.applications.commandsmonitor.events.SelectionChangedEvent;
import csbase.client.applications.commandsmonitor.models.CommandsFilterDTO;
import csbase.client.applications.commandsmonitor.models.CommandsTableDTO;
import csbase.client.applications.commandsmonitor.models.TablesTabDTO;
import csbase.client.applications.commandsmonitor.table.CommandsTableFactory;
import csbase.client.desktop.Task;
import csbase.client.util.event.EventListener;
import csbase.client.util.event.EventManager;
import csbase.client.util.event.IEvent;
import csbase.logic.CommandStatus;
import csbase.logic.RemoteFileInputStream;
import csbase.remote.ApplicationServiceInterface;
import csbase.remote.ClientRemoteLocator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import tecgraf.ftc.common.logic.RemoteFileChannelInfo;
import tecgraf.javautils.configurationmanager.Configuration;
import tecgraf.javautils.configurationmanager.ConfigurationManager;
import tecgraf.javautils.gui.StatusBar;
import tecgraf.javautils.gui.SwingThreadDispatcher;

public class CommandsMonitor
extends Application {
    private EventManager eventManager = new EventManager();
    private ShowCommandParametersAction showParametersAction;
    private ShowCommandLogAction showLogAction;
    private ShowCommandDetailsAction showDetailsAction;
    private ExecuteCommandAction executeCommandAction;
    private KillCommandsAction killCommandsAction;
    private RemoveCommandsAction removeCommandsAction;

    public CommandsMonitor(String id) throws ApplicationException {
        super(id);
        try {
            this.createActions();
            this.eventManager.addEventListener(this.showParametersAction, DoubleClickEvent.class);
            XmlConfigDAO config = this.createConfigDAO();
            this.getApplicationFrame().getContentPane().add(this.createContentPane(config));
            this.getApplicationFrame().setJMenuBar(this.createMenuBar(config));
            this.getApplicationFrame().pack();
        }
        catch (ApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ApplicationException(e);
        }
    }

    public void addSelectionChangedListener(EventListener<SelectionChangedEvent> listener) {
        this.eventManager.addEventListener(listener, SelectionChangedEvent.class);
    }

    @Override
    public void startApplication() throws ApplicationException {
        this.eventManager.fireEvent(new ActionEvent(ActionEvent.Type.started));
        super.startApplication();
    }

    @Override
    public void killApplication() {
        this.eventManager.fireEvent(new ActionEvent(ActionEvent.Type.killed));
    }

    @Override
    protected boolean userCanKillApplication() {
        return true;
    }

    private void createActions() {
        this.showParametersAction = new ShowCommandParametersAction(this);
        this.showLogAction = new ShowCommandLogAction(this);
        this.showDetailsAction = new ShowCommandDetailsAction(this);
        this.executeCommandAction = new ExecuteCommandAction(this);
        this.killCommandsAction = new KillCommandsAction(this);
        this.removeCommandsAction = new RemoveCommandsAction(this);
    }

    private JMenuBar createMenuBar(XmlConfigDAO config) {
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(this.createCommandsMenu());
        if (this.acceptCommandsFromStatus(CommandStatus.SCHEDULED, config)) {
            menuBar.add(this.createSchedulerMenu());
        }
        return menuBar;
    }

    private JMenu createSchedulerMenu() {
        JMenu schedulerMenu = new JMenu(this.getString("CommandsMonitor.menu.scheduler"));
        SchedulerSwitchAction switchAction = new SchedulerSwitchAction(this);
        final JCheckBoxMenuItem switchItem = new JCheckBoxMenuItem(switchAction);
        boolean isBlocked = switchAction.isSchedulerBlocked();
        switchItem.setSelected(isBlocked);
        this.showBloquedQueueWarning(isBlocked);
        switchAction.addStateChangedListener(new EventListener<SchedulerSwitchAction.StateChangedEvent>(){

            @Override
            public void eventFired(SchedulerSwitchAction.StateChangedEvent event) {
                boolean isBlocked = event.isSchedulerBlocked();
                CommandsMonitor.this.showBloquedQueueWarning(isBlocked);
                switchItem.setSelected(isBlocked);
            }
        });
        schedulerMenu.add(switchItem);
        return schedulerMenu;
    }

    private void showBloquedQueueWarning(boolean show) {
        StatusBar sb = this.getApplicationFrame().getStatusBar();
        if (show) {
            sb.setWarning(this.getString("CommandsMonitor.warning.blockedQueue"));
        } else {
            sb.clearStatus();
        }
    }

    private JMenu createCommandsMenu() {
        JMenu commandsMenu = new JMenu(this.getString("CommandsMonitor.menu.commands"));
        commandsMenu.add(new JMenuItem(this.showParametersAction));
        commandsMenu.add(new JMenuItem(this.showLogAction));
        commandsMenu.add(new JMenuItem(this.showDetailsAction));
        commandsMenu.add(new JMenuItem(this.executeCommandAction));
        commandsMenu.add(new JMenuItem(this.killCommandsAction));
        commandsMenu.add(new JMenuItem(this.removeCommandsAction));
        if (this.hasAdvancedMenu()) {
            commandsMenu.addSeparator();
            JMenu advancedSubMenu = this.createAdvancedMenu();
            commandsMenu.add(advancedSubMenu);
        }
        commandsMenu.addSeparator();
        commandsMenu.add(new ApplicationExitAction(this));
        return commandsMenu;
    }

    private boolean hasAdvancedMenu() {
        ConfigurationManager cnfManager = ConfigurationManager.getInstance();
        if (cnfManager == null) {
            return false;
        }
        try {
            Class<CommandsMonitor> propClass = CommandsMonitor.class;
            Configuration cnf = cnfManager.getConfiguration(propClass);
            String propName = "enable.advanced.menu";
            return cnf.getOptionalBooleanProperty("enable.advanced.menu", false);
        }
        catch (Exception e) {
            return false;
        }
    }

    private JMenu createAdvancedMenu() {
        JMenu advancedSubMenu = new JMenu(this.getString("CommandsMonitor.menu.advanced"));
        advancedSubMenu.add(new JMenuItem(new RefreshCommandsAction(this)));
        advancedSubMenu.add(new JMenuItem(new ShowCommandDirAction(this)));
        return advancedSubMenu;
    }

    private JComponent createContentPane(XmlConfigDAO config) throws ApplicationException {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.createToolBar(), "North");
        panel.add(this.createCenterPane(config), "Center");
        this.getApplicationFrame().showStatusBar();
        if (this.acceptCommandsFromStatus(CommandStatus.FINISHED, config) || this.acceptCommandsFromStatus(CommandStatus.SYSTEM_FAILURE, config)) {
            final EventListener<FinishedOrSystemFailureCommandsLoadingEvent> loadingListener = new EventListener<FinishedOrSystemFailureCommandsLoadingEvent>(){

                @Override
                public void eventFired(final FinishedOrSystemFailureCommandsLoadingEvent event) {
                    SwingThreadDispatcher.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            StatusBar statusbar = CommandsMonitor.this.getApplicationFrame().getStatusBar();
                            if (event.finished()) {
                                statusbar.clearStatus();
                            } else {
                                Object[] args = new Object[]{event.getLoaded(), event.getMissing(), event.getTotal() - event.getMissing(), event.getTotal()};
                                statusbar.setStatus(CommandsMonitor.this.getString("CommandsMonitor.statusbar.commands.loading", args));
                            }
                        }
                    });
                }
            };
            this.eventManager.addEventListener(new EventListener<ActionEvent>(){

                @Override
                public void eventFired(ActionEvent event) {
                    if (event.type == ActionEvent.Type.started) {
                        CommandsCache.getInstance().addEventListener(loadingListener);
                    } else if (event.type == ActionEvent.Type.killed) {
                        CommandsCache.getInstance().removeEventListener(loadingListener);
                    }
                }
            }, ActionEvent.class);
        }
        return panel;
    }

    private JToolBar createToolBar() {
        JToolBar toolBar = new JToolBar();
        toolBar.setOrientation(0);
        toolBar.add(this.showParametersAction);
        toolBar.add(this.showLogAction);
        toolBar.add(this.showDetailsAction);
        toolBar.add(this.executeCommandAction);
        toolBar.add(this.killCommandsAction);
        toolBar.add(this.removeCommandsAction);
        return toolBar;
    }

    private Component createCenterPane(XmlConfigDAO config) throws ApplicationException {
        CommandsTableFactory tablesFactory = new CommandsTableFactory(this.getApplicationRegistry(), config);
        List<TablesTabDTO> tabsInfo = config.getTabsInfo();
        if (tabsInfo.size() < 1) {
            throw new ApplicationException("Deve existir pelo menos uma aba configurada.");
        }
        if (tabsInfo.size() == 1) {
            TablesTabDTO tab = tabsInfo.get(0);
            final TablesPanel panel = new TablesPanel(tab.getTablesId(), tablesFactory, this.getApplicationRegistry(), this.eventManager);
            this.eventManager.addEventListener(new EventListener<ActionEvent>(){

                @Override
                public void eventFired(ActionEvent event) {
                    if (event.type == ActionEvent.Type.started) {
                        panel.start();
                    } else if (event.type == ActionEvent.Type.killed) {
                        panel.stop();
                    }
                }
            }, ActionEvent.class);
            return panel;
        }
        final TablesTabbedPane panel = new TablesTabbedPane(config, tablesFactory, this.getApplicationRegistry(), this.eventManager);
        this.eventManager.addEventListener(new EventListener<ActionEvent>(){

            @Override
            public void eventFired(ActionEvent event) {
                if (event.type == ActionEvent.Type.started) {
                    panel.start();
                } else if (event.type == ActionEvent.Type.killed) {
                    panel.stop();
                }
            }
        }, ActionEvent.class);
        return panel;
    }

    private XmlConfigDAO createConfigDAO() throws ApplicationException {
        final ApplicationServiceInterface appService = ClientRemoteLocator.applicationService;
        Task<XmlConfigDAO> task = new Task<XmlConfigDAO>(){

            protected void performTask() throws Exception {
                String[] configXmlPath = new String[]{"config.xml"};
                RemoteFileChannelInfo info = appService.getApplicationResource(CommandsMonitor.this.getId(), configXmlPath);
                if (info == null) {
                    throw new RuntimeException("Arquivo n\u00e3o encontrado: config.xml");
                }
                RemoteFileInputStream in = new RemoteFileInputStream(info);
                InputStreamReader reader = new InputStreamReader((InputStream)in);
                this.setResult(new XmlConfigDAO(reader));
            }
        };
        ApplicationFrame frame = this.getApplicationFrame();
        if (task.execute(frame, this.getName(), this.getString("task.configdao.create.message"))) {
            return (XmlConfigDAO)task.getResult();
        }
        String msg = this.getString("task.configdao.create.error");
        throw new ApplicationException(msg, task.getError());
    }

    public boolean acceptCommandsFromStatus(CommandStatus status, XmlConfigDAO config) {
        HashMap<String, CommandsTableDTO> tablesById = new HashMap<String, CommandsTableDTO>();
        for (CommandsTableDTO tableInfo : config.getTablesInfo()) {
            tablesById.put(tableInfo.getId(), tableInfo);
        }
        HashMap<String, CommandsFilterDTO> filtersById = new HashMap<String, CommandsFilterDTO>();
        for (CommandsFilterDTO filterInfo : config.getFiltersInfo()) {
            filtersById.put(filterInfo.getId(), filterInfo);
        }
        for (TablesTabDTO tabInfo : config.getTabsInfo()) {
            for (String tableId : tabInfo.getTablesId()) {
                CommandsTableDTO tableInfo = (CommandsTableDTO)tablesById.get(tableId);
                CommandsFilterDTO filterInfo = (CommandsFilterDTO)filtersById.get(tableInfo.getFilterId());
                if (filterInfo.areStatusesIncluded()) {
                    for (CommandStatus aStatus : filterInfo.getStatuses()) {
                        if (!aStatus.equals((Object)status)) continue;
                        return true;
                    }
                    continue;
                }
                boolean excluded = false;
                for (CommandStatus aStatus : filterInfo.getStatuses()) {
                    if (!aStatus.equals((Object)status)) continue;
                    excluded = true;
                    break;
                }
                if (excluded) continue;
                return true;
            }
        }
        return false;
    }

    static class ActionEvent
    implements IEvent {
        private Type type;

        ActionEvent(Type type) {
            this.type = type;
        }

        static enum Type {
            started,
            killed;

        }
    }
}

