/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.filetransfer;

import csbase.client.applications.AbstractSimpleApplicationPanel;
import csbase.client.applications.Application;
import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.filetransfer.ProjectComboBox;
import csbase.client.applications.filetransfer.ReadProjectTask;
import csbase.client.desktop.DesktopFrame;
import csbase.client.kernel.ClientException;
import csbase.client.project.ProjectTree;
import csbase.client.project.ProjectTreeFactory;
import csbase.logic.CommonClientProject;
import csbase.logic.ProjectFileFilter;
import csbase.logic.UserProjectInfo;
import csbase.logic.filters.ProjectFileCompositeOrFilter;
import csbase.logic.filters.ProjectFileDirectoryFilter;
import csbase.logic.filters.ProjectFileTypeFilter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import tecgraf.javautils.gui.GBC;

public class ProjectFileSelectorPanel
extends AbstractSimpleApplicationPanel<Application> {
    protected ProjectTree projectTree;
    protected ProjectComboBox projectCombo;
    private CommonClientProject project;
    private ReadProjectTask readProjecTask;
    private String comboLabel;
    protected JScrollPane projectPanel;

    public ProjectFileSelectorPanel(final Application application, boolean selectOpenProject, String comboLabel, boolean singleSelection, String ... fileTypes) {
        super(application);
        CommonClientProject currentProject;
        this.setLayout(new GridBagLayout());
        this.comboLabel = comboLabel;
        this.projectCombo = new ProjectComboBox(application);
        this.projectCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ProjectFileSelectorPanel.this.project = ProjectFileSelectorPanel.this.openProjectAction(application, ProjectFileSelectorPanel.this.project, ProjectFileSelectorPanel.this.projectCombo, ProjectFileSelectorPanel.this.projectTree);
            }
        });
        try {
            this.projectTree = this.createProjectTree(this.project, singleSelection, fileTypes);
            this.projectPanel = new JScrollPane(this.projectTree.getTree());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.buildPanel();
        if (selectOpenProject && (currentProject = DesktopFrame.getInstance().getProject()) != null) {
            this.projectCombo.setSelectedItem(new UserProjectInfo(currentProject.getId(), currentProject.getName(), currentProject.getUserId()));
        }
    }

    public ProjectTree getProjectTree() {
        return this.projectTree;
    }

    public ProjectComboBox getProjectCombo() {
        return this.projectCombo;
    }

    public CommonClientProject getProject() {
        return this.project;
    }

    public void removeObservers() {
        try {
            if (this.project != null) {
                this.project.uninstallObserver();
            }
            this.projectCombo.deleteObserver();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void buildPanel() {
        this.add((Component)new JLabel(this.comboLabel), new GBC(0, 0).northwest());
        this.add((Component)this.projectCombo, new GBC(1, 0).northwest().insets(0, 5, 10, 0));
        this.projectPanel.setPreferredSize(new Dimension(200, 465));
        this.add((Component)this.projectPanel, new GBC(0, 1).both().northwest().insets(0, 0, 0, 0).width(2));
    }

    protected ProjectTree createProjectTree(CommonClientProject project, boolean singleSelection, String ... fileTypes) throws ClientException {
        ProjectFileCompositeOrFilter filter = null;
        if (fileTypes.length != 0) {
            ProjectFileTypeFilter fileFilter = new ProjectFileTypeFilter(fileTypes);
            ProjectFileDirectoryFilter dirFilter = ProjectFileDirectoryFilter.getInstance();
            filter = new ProjectFileCompositeOrFilter();
            filter.addChild((ProjectFileFilter)fileFilter);
            filter.addChild((ProjectFileFilter)dirFilter);
        }
        ApplicationFrame frame = ((Application)this.getApplication()).getApplicationFrame();
        ProjectTree projectTree = ProjectTreeFactory.getInstance().makeProjectTree(frame, frame.getTitle(), project, (ProjectFileFilter)filter);
        projectTree.setSingleSelectionMode(singleSelection);
        projectTree.enableRenameAction(false);
        projectTree.enableDeleteAction(false);
        projectTree.addMouseListener();
        return projectTree;
    }

    private CommonClientProject openProjectAction(Application application, CommonClientProject project, ProjectComboBox projectCombo, ProjectTree projectTree) {
        if (projectCombo.getSelectedItem() == null) {
            return null;
        }
        if (this.readProjecTask == null) {
            this.readProjecTask = new ReadProjectTask(projectTree, projectCombo, project);
        }
        if (this.readProjecTask.execute(application.getApplicationFrame(), application.getName(), this.getString("ProjectFileSelectorPanel.wait.message"))) {
            return (CommonClientProject)this.readProjecTask.getResult();
        }
        return null;
    }
}

