/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.flowapplication.graph;

import csbase.client.applications.flowapplication.graph.Graph;
import csbase.client.applications.flowapplication.graph.GraphElement;
import csbase.client.applications.flowapplication.graph.GraphElementListener;
import csbase.client.applications.flowapplication.graph.GraphFileDescriptor;
import csbase.client.applications.flowapplication.graph.GraphNode;
import csbase.client.applications.flowapplication.graph.GraphPoint;
import csbase.client.applications.flowapplication.graph.Grid;
import csbase.client.applications.flowapplication.messages.ErrorMessage;
import csbase.client.applications.flowapplication.messages.PickLinkMessage;
import csbase.client.applications.flowapplication.messages.PickNodeMessage;
import csbase.logic.algorithms.parameters.AbstractFileParameter;
import csbase.logic.algorithms.parameters.FileParameterListener;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.SimpleParameterListener;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.vix.TypeMessage;
import tecgraf.vix.TypeVO;

public final class GraphLink
extends GraphElement
implements FileParameterListener,
SimpleParameterListener {
    private static final Color DEFAULT_COLOR = Color.BLACK;
    private static final Color ERROR_COLOR = Color.RED;
    private static final Color BYPASSED_COLOR = new Color(150, 150, 150);
    private static final Color REMOVE_LINE_COLOR = new Color(255, 255, 100);
    private static final Stroke STROKE = new BasicStroke(1.0f, 0, 1);
    private Color color;
    private Path2D path;
    private GraphFileDescriptor inputFileDescriptor;
    private boolean isHighlighted;
    private GraphFileDescriptor outputFileDescriptor;
    private final List<GraphPoint> pointList = new ArrayList<GraphPoint>();
    private GraphPoint temporaryPoint;

    GraphLink(Graph graph, int id) {
        super(graph, id);
        this.createShape();
        this.updateColor();
    }

    public boolean breakPoint(Point2D point) {
        GraphPoint graphPoint = new GraphPoint(point);
        for (int i = 1; i < this.pointList.size(); ++i) {
            GraphPoint nextPoint;
            GraphPoint priorPoint = this.pointList.get(i - 1);
            if (!this.contains(graphPoint, priorPoint, nextPoint = this.pointList.get(i))) continue;
            this.pointList.add(i, new GraphPoint(point));
            return true;
        }
        return false;
    }

    public void breakAsOrthogonalLink() {
        this.breakAsOrthogonalLinkAt(null);
    }

    private void breakAsOrthogonalLinkAt(Double y) {
        GraphPoint firstPoint = this.pointList.get(0);
        Point2D outputPoint = firstPoint.getLocation();
        GraphPoint lastPoint = this.pointList.get(this.pointList.size() - 1);
        Point2D inputPoint = lastPoint.getLocation();
        double deltaX = inputPoint.getX() - outputPoint.getX();
        double deltaY = inputPoint.getY() - outputPoint.getY();
        this.removeIntermediatePoints();
        if (deltaX != 0.0 && deltaY != 0.0) {
            double newY = y == null ? outputPoint.getY() + deltaY / 2.0 : y;
            Point2D.Double outputBreakPoint = new Point2D.Double();
            Point2D.Double inputBreakPoint = new Point2D.Double();
            ((Point2D)outputBreakPoint).setLocation(outputPoint.getX(), newY);
            ((Point2D)inputBreakPoint).setLocation(inputPoint.getX(), newY);
            GraphPoint inputGraphPoint = new GraphPoint(Grid.adjustPoint(inputBreakPoint));
            GraphPoint outputGraphPoint = new GraphPoint(Grid.adjustPoint(outputBreakPoint));
            this.pointList.add(1, outputGraphPoint);
            this.pointList.add(2, inputGraphPoint);
            this.createShape();
            this.repaint();
        }
    }

    private void removeIntermediatePoints() {
        if (this.pointList.size() > 2) {
            this.pointList.subList(1, this.pointList.size() - 1).clear();
            this.createShape();
            this.repaint();
        }
    }

    @Override
    public void callbackRepaint(Graphics2D g) {
        super.callbackRepaint(g);
        if (this.path != null) {
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g.setPaint(this.color);
            g.setStroke(STROKE);
            g.draw(this.path);
            if (this.isSelected()) {
                for (int i = 0; i < this.pointList.size(); ++i) {
                    GraphPoint point = this.pointList.get(i);
                    point.paint(g);
                }
                if (this.temporaryPoint != null) {
                    this.temporaryPoint.paint(g);
                }
            }
        }
    }

    @Override
    public void deattach() {
        if (this.inputFileDescriptor != null) {
            this.inputFileDescriptor.setLinkTo(null);
            this.setInputFileDescriptor(null);
        }
        if (this.outputFileDescriptor != null) {
            this.outputFileDescriptor.removeLinkFrom(this);
            this.setOutputFileDescriptor(null);
        }
        super.deattach();
    }

    public boolean finish(GraphFileDescriptor inputDescriptor) {
        if (inputDescriptor == null) {
            throw new IllegalArgumentException("O par\u00e2metro inputFileDescriptor est\u00e1 nulo.");
        }
        AbstractFileParameter inputParameter = inputDescriptor.getFileParameter();
        if (inputParameter == null) {
            return false;
        }
        if (this.outputFileDescriptor != null) {
            AbstractFileParameter outputParameter = this.outputFileDescriptor.getFileParameter();
            if (outputParameter == null) {
                return false;
            }
            Object[] outputFileType = outputParameter.getFileTypes();
            Object[] inputFileType = inputParameter.getFileTypes();
            if (inputFileType == null && outputFileType != null || inputFileType != null && !Arrays.equals(inputFileType, outputFileType)) {
                if (outputFileType == null) {
                    outputFileType = new String[]{LNG.get((String)(GraphLink.class.getName() + ".unknownFileType"))};
                }
                if (inputFileType == null) {
                    inputFileType = new String[]{LNG.get((String)(GraphLink.class.getName() + ".unknownFileType"))};
                }
                new ErrorMessage(GraphLink.class.getName() + ".error_different_file_types", outputFileType, inputFileType).sendVS(this.getVS());
                return false;
            }
        }
        GraphNode node = inputDescriptor.getNode();
        if (inputDescriptor.getLinkTo() != null) {
            this.removeLastPoint();
            new ErrorMessage(GraphLink.class.getName() + ".error_only_one_link").sendVS(this.getVS());
            return false;
        }
        if (node.canReach(this.getStartNode())) {
            this.removeLastPoint();
            new ErrorMessage(GraphLink.class.getName() + ".error_create_cicle").sendVS(this.getVS());
            return false;
        }
        this.setEnd(inputDescriptor);
        return true;
    }

    public Rectangle2D getBounds2D() {
        if (this.path == null) {
            return new Rectangle2D.Double();
        }
        BasicStroke stroke = new BasicStroke();
        Shape shape = stroke.createStrokedShape(this.path);
        Rectangle2D bounds2d = shape.getBounds2D();
        return bounds2d;
    }

    @Override
    public String getHint(Point2D point) {
        if (!this.contains(point)) {
            return null;
        }
        return this.toString();
    }

    public GraphFileDescriptor getInputFileDescriptor() {
        return this.inputFileDescriptor;
    }

    public List<Point2D> getPointList() {
        ArrayList<Point2D> newPointList = new ArrayList<Point2D>(this.pointList.size());
        for (int i = 0; i < this.pointList.size(); ++i) {
            GraphPoint graphPoint = this.pointList.get(i);
            newPointList.add(graphPoint.getLocation());
        }
        return Collections.unmodifiableList(newPointList);
    }

    public List<Point2D> getIntermediatePointList() {
        ArrayList<Point2D> newPointList = new ArrayList<Point2D>(this.pointList.size());
        for (int i = 1; i < this.pointList.size() - 1; ++i) {
            GraphPoint graphPoint = this.pointList.get(i);
            newPointList.add(graphPoint.getLocation());
        }
        return Collections.unmodifiableList(newPointList);
    }

    public GraphFileDescriptor getOutputFileDescriptor() {
        return this.outputFileDescriptor;
    }

    public void hasLinkWasChanged(AbstractFileParameter parameter) {
        this.updateColor();
        this.repaint();
    }

    public void increase(Point2D point) {
        GraphPoint previousPoint;
        Point2D pt = Grid.adjustPoint(point);
        GraphPoint graphPoint = new GraphPoint(pt);
        this.pointList.add(graphPoint);
        if (this.pointList.size() != 1 && this.canBeRemoved(previousPoint = this.pointList.get(this.pointList.size() - 2))) {
            this.pointList.remove(previousPoint);
        }
        this.createShape();
        for (GraphElementListener listener : this.getListenerList()) {
            listener.wasIncreased(this);
        }
    }

    @Override
    public boolean msgHandlerVO(TypeMessage msg) {
        if (msg instanceof PickLinkMessage) {
            return this.handlePickLinkMessage((PickLinkMessage)msg);
        }
        return super.msgHandlerVO(msg);
    }

    public void pretentToIncrease(Point2D pt) {
        this.temporaryPoint = new GraphPoint(pt);
        this.createShape();
    }

    public void removeLastPoint() {
        this.pointList.remove(this.pointList.size() - 1);
    }

    public void setEnd(GraphFileDescriptor inputFileDescriptor) {
        if (inputFileDescriptor == null) {
            throw new IllegalArgumentException("O par\u00e2metro inputFileDescriptor est\u00e1 nulo.");
        }
        inputFileDescriptor.setLinkTo(this);
        this.setInputFileDescriptor(inputFileDescriptor);
        this.createShape();
    }

    public void setStart(GraphFileDescriptor outputFileDescriptor) {
        if (outputFileDescriptor == null) {
            throw new IllegalArgumentException("O par\u00e2metro outputFileDescriptor est\u00e1 nulo.");
        }
        outputFileDescriptor.addLinkFrom(this);
        this.setOutputFileDescriptor(outputFileDescriptor);
        this.createShape();
    }

    public boolean start(GraphFileDescriptor outputDescriptor) {
        if (outputDescriptor.getFileParameter() == null) {
            return false;
        }
        GraphNode node = outputDescriptor.getNode();
        if (this.inputFileDescriptor != null) {
            Object[] inputFileType = this.inputFileDescriptor.getFileParameter().getFileTypes();
            Object[] outputFileType = outputDescriptor.getFileParameter().getFileTypes();
            if (inputFileType == null && outputFileType != null || inputFileType != null && !Arrays.equals(inputFileType, outputFileType)) {
                if (outputFileType == null) {
                    outputFileType = new String[]{LNG.get((String)(GraphLink.class.getName() + ".unknownFileType"))};
                }
                if (inputFileType == null) {
                    inputFileType = new String[]{LNG.get((String)(GraphLink.class.getName() + ".unknownFileType"))};
                }
                new ErrorMessage(GraphLink.class.getName() + ".error_different_file_types", outputFileType, inputFileType).sendVS(this.getVS());
                return false;
            }
        }
        if (this.getEndNode() != null && this.getEndNode().canReach(node)) {
            this.removeLastPoint();
            new ErrorMessage(GraphLink.class.getName() + ".error_create_cicle").sendVS(this.getVS());
            return false;
        }
        this.setStart(outputDescriptor);
        return true;
    }

    public String toString() {
        String start = this.outputFileDescriptor == null ? "X" : this.outputFileDescriptor.toString();
        String end = this.inputFileDescriptor == null ? "X" : this.inputFileDescriptor.toString();
        return start + " -> " + end;
    }

    @Override
    public boolean turnOnHighlight(Point2D pt) {
        if (!this.contains(pt)) {
            return false;
        }
        this.isHighlighted = true;
        this.updateColor();
        return true;
    }

    @Override
    public void turnOffHighlight() {
        this.isHighlighted = false;
        this.updateColor();
    }

    public void typeWasChanged(AbstractFileParameter parameter) {
        this.updateColor();
        this.repaint();
        for (GraphElementListener listener : this.getListenerList()) {
            listener.wasLinkStatusChanged(this);
        }
    }

    public void capabilityWasChanged(SimpleParameter parameter) {
        this.updateColor();
    }

    public void defaultValueWasChanged(SimpleParameter parameter) {
    }

    public void labelWasChanged(SimpleParameter parameter) {
    }

    public void valueWasChanged(SimpleParameter parameter) {
    }

    public void visibilityWasChanged(SimpleParameter parameter) {
        this.updateColor();
    }

    @Override
    protected boolean contains(Point2D pt) {
        GraphPoint point = new GraphPoint(pt);
        for (int i = 1; i < this.pointList.size(); ++i) {
            GraphPoint endPoint;
            GraphPoint startPoint = this.pointList.get(i - 1);
            if (!this.contains(point, startPoint, endPoint = this.pointList.get(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean doDrag(Point2D startPoint, Point2D endPoint) {
        Point2D adjustedPoint = this.adjustPoint(endPoint);
        int indexOf = this.pointList.indexOf(new GraphPoint(startPoint));
        if (indexOf < 0) {
            return false;
        }
        this.pointList.set(indexOf, new GraphPoint(adjustedPoint));
        if (indexOf == 0) {
            this.moveFirstPoint(adjustedPoint);
        } else if (indexOf == this.pointList.size() - 1) {
            this.moveLastPoint(adjustedPoint);
        }
        this.createShape();
        this.updateColor();
        if (this.canBeRemoved(new GraphPoint(Grid.adjustPoint(adjustedPoint)))) {
            this.color = REMOVE_LINE_COLOR;
            this.repaint();
        }
        return true;
    }

    @Override
    protected void doDrag(double tx, double ty) {
        for (int i = 1; i < this.pointList.size() - 1; ++i) {
            GraphPoint graphPoint = this.pointList.get(i);
            Point2D point = graphPoint.getLocation();
            double x = point.getX() + tx;
            double y = point.getY() + ty;
            Point2D newPoint = new Point2D.Double(x, y);
            newPoint = this.adjustPoint(newPoint);
            graphPoint.setLocation(newPoint.getX(), newPoint.getY());
        }
    }

    @Override
    protected void doDrop(Point2D pt) {
        GraphNode node;
        PickNodeMessage message;
        GraphPoint graphPoint = new GraphPoint(pt);
        if (this.canBeRemoved(graphPoint)) {
            this.pointList.remove(graphPoint);
        } else if (this.pointList.indexOf(graphPoint) == 0) {
            message = new PickNodeMessage(pt);
            message.sendVO((TypeVO)this.getGraph());
            node = message.getNode();
            if (node != null) {
                node.startLink(this, pt);
            } else {
                this.deattach();
            }
        } else if (this.pointList.indexOf(graphPoint) == this.pointList.size() - 1) {
            message = new PickNodeMessage(pt);
            message.sendVO((TypeVO)this.getGraph());
            node = message.getNode();
            if (node != null) {
                node.finishLink(this, pt);
            } else {
                this.deattach();
            }
        }
        for (int i = 1; i < this.pointList.size() - 1; ++i) {
            GraphPoint currentGraphPoint = this.pointList.get(i);
            this.pointList.set(i, new GraphPoint(Grid.adjustPoint(currentGraphPoint.getLocation())));
        }
        this.createShape();
    }

    @Override
    protected void reset() {
        super.reset();
        if (this.temporaryPoint != null) {
            this.deattach();
        }
    }

    public GraphNode getEndNode() {
        if (this.inputFileDescriptor != null) {
            return this.inputFileDescriptor.getNode();
        }
        return null;
    }

    public GraphNode getStartNode() {
        if (this.outputFileDescriptor != null) {
            return this.outputFileDescriptor.getNode();
        }
        return null;
    }

    public boolean isWellFormed() {
        if (this.outputFileDescriptor == null) {
            return false;
        }
        if (!this.outputFileDescriptor.isWellFormed()) {
            return false;
        }
        if (this.inputFileDescriptor == null) {
            return false;
        }
        if (!this.inputFileDescriptor.isWellFormed()) {
            return false;
        }
        if (!this.outputFileDescriptor.hasValidNumberOfLinks()) {
            return false;
        }
        AbstractFileParameter outputParameter = this.outputFileDescriptor.getFileParameter();
        AbstractFileParameter inputParameter = this.inputFileDescriptor.getFileParameter();
        Object[] outputFileType = outputParameter.getFileTypes();
        Object[] inputFileType = inputParameter.getFileTypes();
        if (outputFileType == null) {
            return inputFileType == null;
        }
        return Arrays.equals(outputFileType, inputFileType);
    }

    void updateEndPoint() {
        this.pointList.set(this.pointList.size() - 1, new GraphPoint(this.inputFileDescriptor.getLinkablePoint()));
        this.temporaryPoint = null;
        this.bringToFront();
        this.createShape();
        this.updateColor();
    }

    void updateStartPoint() {
        this.pointList.set(0, new GraphPoint(this.outputFileDescriptor.getLinkablePoint()));
        this.temporaryPoint = null;
        this.bringToFront();
        this.createShape();
        this.updateColor();
    }

    private Point2D adjustPoint(Point2D point) {
        double x = Math.max(point.getX(), 0.0);
        double y = Math.max(point.getY(), 0.0);
        Point2D.Double newEndPoint = new Point2D.Double(x, y);
        return newEndPoint;
    }

    private boolean canBeRemoved(GraphPoint point) {
        int indexOf = this.pointList.indexOf(point);
        if (indexOf < 0) {
            return false;
        }
        if (indexOf == 0) {
            return false;
        }
        if (indexOf == this.pointList.size() - 1) {
            return false;
        }
        GraphPoint priorPoint = this.pointList.get(indexOf - 1);
        GraphPoint nextPoint = this.pointList.get(indexOf + 1);
        return this.contains(point, priorPoint, nextPoint);
    }

    private boolean contains(GraphPoint point, GraphPoint startPoint, GraphPoint endPoint) {
        if (point.equals(startPoint)) {
            return true;
        }
        if (point.equals(endPoint)) {
            return true;
        }
        Line2D.Double line = new Line2D.Double(startPoint.getLocation(), endPoint.getLocation());
        return line.intersects(point.getBounds());
    }

    private void createShape() {
        if (!this.pointList.isEmpty()) {
            GraphPoint graphPoint = this.pointList.get(0);
            Point2D point = graphPoint.getLocation();
            this.path = new Path2D.Float();
            this.path.moveTo((float)point.getX(), (float)point.getY());
            for (int i = 1; i < this.pointList.size(); ++i) {
                graphPoint = this.pointList.get(i);
                point = graphPoint.getLocation();
                this.path.lineTo((float)point.getX(), (float)point.getY());
            }
            if (this.temporaryPoint != null) {
                point = this.temporaryPoint.getLocation();
                this.path.lineTo((float)point.getX(), (float)point.getY());
            }
        }
    }

    private boolean handlePickLinkMessage(PickLinkMessage message) {
        if (this.contains(message.getPoint())) {
            message.setLink(this);
            return true;
        }
        return false;
    }

    private void moveFirstPoint(Point2D pt) {
        if (this.outputFileDescriptor != null && !this.outputFileDescriptor.getBounds2D().contains(pt)) {
            this.outputFileDescriptor.removeLinkFrom(this);
            this.setOutputFileDescriptor(null);
        }
    }

    private void moveLastPoint(Point2D pt) {
        if (this.inputFileDescriptor != null && !this.inputFileDescriptor.getBounds2D().contains(pt)) {
            this.inputFileDescriptor.setLinkTo(null);
            this.setInputFileDescriptor(null);
        }
    }

    private void notifyAnchored(GraphFileDescriptor descriptor) {
        for (GraphElementListener listener : this.getListenerList()) {
            listener.wasAnchored(this, descriptor);
        }
    }

    private void notifyUnanchored(GraphFileDescriptor descriptor) {
        for (GraphElementListener listener : this.getListenerList()) {
            listener.wasUnanchored(this, descriptor);
        }
    }

    private void setInputFileDescriptor(GraphFileDescriptor descriptor) {
        if (descriptor == null) {
            if (this.inputFileDescriptor != null) {
                GraphFileDescriptor oldDescriptor = this.inputFileDescriptor;
                AbstractFileParameter fileParameter = this.inputFileDescriptor.getFileParameter();
                if (fileParameter != null) {
                    fileParameter.removeFileParameterListener((FileParameterListener)this);
                    fileParameter.removeSimpleParameterListener((SimpleParameterListener)this);
                }
                this.updateColor();
                this.notifyUnanchored(oldDescriptor);
                this.inputFileDescriptor = null;
            }
        } else {
            this.inputFileDescriptor = descriptor;
            this.updateEndPoint();
            this.updateColor();
            this.notifyAnchored(this.inputFileDescriptor);
            AbstractFileParameter fileParameter = this.inputFileDescriptor.getFileParameter();
            if (fileParameter != null) {
                fileParameter.addParameterListener((FileParameterListener)this);
                fileParameter.addSimpleParameterListener((SimpleParameterListener)this);
            }
        }
    }

    private void setOutputFileDescriptor(GraphFileDescriptor descriptor) {
        if (descriptor == null) {
            if (this.outputFileDescriptor != null) {
                GraphFileDescriptor oldDescriptor = this.outputFileDescriptor;
                AbstractFileParameter fileParameter = this.outputFileDescriptor.getFileParameter();
                if (fileParameter != null) {
                    fileParameter.removeFileParameterListener((FileParameterListener)this);
                    fileParameter.removeSimpleParameterListener((SimpleParameterListener)this);
                }
                this.updateColor();
                this.notifyUnanchored(oldDescriptor);
                this.outputFileDescriptor = null;
            }
        } else {
            this.outputFileDescriptor = descriptor;
            this.updateStartPoint();
            this.updateColor();
            AbstractFileParameter fileParameter = this.outputFileDescriptor.getFileParameter();
            this.notifyAnchored(this.outputFileDescriptor);
            if (fileParameter != null) {
                fileParameter.addParameterListener((FileParameterListener)this);
                fileParameter.addSimpleParameterListener((SimpleParameterListener)this);
            }
        }
    }

    private void updateColor() {
        this.color = !this.isWellFormed() ? ERROR_COLOR : (this.isHighlighted ? HIGHT_LIGHT_COLOR : (this.isBypassed() ? BYPASSED_COLOR : DEFAULT_COLOR));
    }

    @Override
    protected void translate(Point2D pt) {
        for (int i = 1; i < this.pointList.size() - 1; ++i) {
            GraphPoint graphPoint = this.pointList.get(i);
            Point2D location = graphPoint.getLocation();
            double newX = pt.getX() + location.getX();
            double newY = pt.getY() + location.getY();
            graphPoint.setLocation(newX, newY);
        }
    }

    public boolean isBypassed() {
        GraphNode inputNode = this.inputFileDescriptor.getNode();
        GraphNode outputNode = this.outputFileDescriptor.getNode();
        if (inputNode != null && outputNode != null) {
            return inputNode.isBypassed() || outputNode.isBypassed();
        }
        return false;
    }
}

