/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsmanager.panels.filters;

import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.models.ProjectSpaceAllocation;
import csbase.client.applications.projectsmanager.models.ProjectsManagerData;
import csbase.client.applications.projectsmanager.models.ProjectsManagerScope;
import csbase.client.applications.projectsmanager.panels.filters.AbstractProjectFilter;
import csbase.client.applications.projectsmanager.panels.filters.BoxRenderer;
import csbase.client.util.user.UserDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.GUIUtils;
import tecgraf.javautils.gui.StandardDialogs;

public class ProjectBasicInfoFilterPanel
extends AbstractProjectFilter {
    private JTextField projectNameField;
    private JPanel projectNamePanel;
    private JLabel projectNameLabel;
    private JTextField projectOwnerField;
    private JPanel projectOwnerPanel;
    private JLabel projectOwnerLabel;
    private JPanel statusComboPanel;
    private JLabel projectStatusLabel;
    private JComboBox projectStatusBox;
    private JPanel sharingComboPanel;
    private JLabel projectSharingLabel;
    private JComboBox projectSharingBox;
    private JButton searchButton;

    public ProjectBasicInfoFilterPanel(ProjectsManager projectsManager) {
        super(projectsManager);
    }

    @Override
    protected void initComponents() {
        this.projectNameLabel = new JLabel(this.getString("ProjectBasicInfoFilterPanel.project.name.label"));
        this.projectNameField = new JTextField();
        this.projectOwnerField = new JTextField();
        this.projectOwnerLabel = new JLabel(this.getString("ProjectBasicInfoFilterPanel.project.owner.id.label"));
        this.projectStatusLabel = new JLabel(this.getString("ProjectBasicInfoFilterPanel.project.status.label"));
        this.projectStatusBox = new JComboBox();
        this.projectSharingLabel = new JLabel(this.getString("ProjectBasicInfoFilterPanel.project.sharing.label"));
        this.projectSharingBox = new JComboBox();
        this.projectNameLabel.setForeground(Color.DARK_GRAY);
        this.projectOwnerLabel.setForeground(Color.DARK_GRAY);
        this.projectStatusLabel.setForeground(Color.DARK_GRAY);
        this.projectSharingLabel.setForeground(Color.DARK_GRAY);
        this.projectStatusBox.addItem(null);
        for (ProjectSpaceAllocation projectSpaceAllocation : ProjectSpaceAllocation.values()) {
            this.projectStatusBox.addItem(projectSpaceAllocation);
        }
        this.projectStatusBox.setRenderer(new BoxRenderer(true));
        this.projectSharingBox.addItem(null);
        for (Enum enum_ : ProjectsManagerScope.values()) {
            if (enum_ == ProjectsManagerScope.NOT_APPLICABLE) continue;
            this.projectSharingBox.addItem(enum_);
        }
        this.projectSharingBox.setRenderer(new BoxRenderer(false));
    }

    @Override
    protected void buildPanel() {
        this.searchButton = new JButton(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectsManager projectsManager = ProjectBasicInfoFilterPanel.this.getProjectsManager();
                ApplicationFrame appFrame = projectsManager.getApplicationFrame();
                String title = ProjectBasicInfoFilterPanel.this.getString("ProjectBasicInfoFilterPanel.user.selection.title");
                try {
                    Set<Object> ids = UserDialog.showUserSelectionDialog(appFrame, projectsManager.getUsers(), false, title);
                    if (ids != null) {
                        Object userId = ids.toArray()[0];
                        ProjectBasicInfoFilterPanel.this.projectOwnerField.setText((String)userId);
                        KeyListener keyListener = ProjectBasicInfoFilterPanel.this.projectOwnerField.getKeyListeners()[0];
                        keyListener.keyReleased(null);
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    String errMsg = ProjectBasicInfoFilterPanel.this.getString("ProjectBasicInfoFilterPanel.user.retrieval.error.message");
                    StandardDialogs.showErrorDialog((Component)appFrame, (String)"Error", (String)errMsg);
                    return;
                }
            }
        });
        this.searchButton.setToolTipText(this.getString("ProjectBasicInfoFilterPanel.tooltip.search.button"));
        this.searchButton.setIcon(ApplicationImages.ICON_FIND_USER_16);
        GUIUtils.trimImageButton((AbstractButton)this.searchButton);
        this.setLayout(new GridBagLayout());
        this.projectNamePanel = new JPanel(new GridBagLayout());
        this.projectNamePanel.add((Component)this.projectNameField, new GBC(0, 0).horizontal());
        this.projectOwnerPanel = new JPanel(new GridBagLayout());
        this.projectOwnerPanel.add((Component)this.projectOwnerField, new GBC(0, 0).horizontal());
        this.projectOwnerPanel.add((Component)this.searchButton, new GBC(1, 0).insets(0, 10, 0, 0));
        this.sharingComboPanel = new JPanel(new GridBagLayout());
        this.sharingComboPanel.add((Component)this.projectSharingBox, new GBC(0, 0).horizontal());
        this.statusComboPanel = new JPanel(new GridBagLayout());
        this.statusComboPanel.add((Component)this.projectStatusBox, new GBC(0, 0).horizontal());
        this.add((Component)this.projectNamePanel, new GBC(0, 0).horizontal());
        this.add((Component)this.projectOwnerPanel, new GBC(1, 0).horizontal());
    }

    @Override
    public boolean projectMatchesFilter(ProjectsManagerData prj) {
        Pattern namePattern = this.convertToPattern(this.projectNameField);
        Pattern ownerPattern = this.convertToPattern(this.projectOwnerField);
        if (namePattern == null || ownerPattern == null) {
            return false;
        }
        return this.projectMatchesFilter(namePattern, ownerPattern, prj);
    }

    private boolean projectMatchesFilter(Pattern namePattern, Pattern ownerPattern, ProjectsManagerData prj) {
        if (namePattern.matcher(prj.getProjectName()).matches() && ownerPattern.matcher(prj.getOwnerId().toString()).matches()) {
            ProjectsManagerScope prjScopeFilter = (ProjectsManagerScope)((Object)this.projectSharingBox.getSelectedItem());
            ProjectSpaceAllocation prjSpaceAllocationFilter = (ProjectSpaceAllocation)((Object)this.projectStatusBox.getSelectedItem());
            if (!(prjScopeFilter != null && prjScopeFilter != prj.getScope() || prjSpaceAllocationFilter != null && prjSpaceAllocationFilter != prj.getProjectSpaceAllocation())) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void runSpecificFilter(List<ProjectsManagerData> allProjects, List<ProjectsManagerData> filteredProjects) {
        boolean validPattern;
        Pattern namePattern = this.convertToPattern(this.projectNameField);
        Pattern ownerPattern = this.convertToPattern(this.projectOwnerField);
        boolean bl = validPattern = namePattern != null && ownerPattern != null;
        if (!validPattern) {
            ProjectsManager projectsManager = this.getProjectsManager();
            projectsManager.showError("<<Erro na especifica\u00e7\u00e3o do filtro>>");
            return;
        }
        for (ProjectsManagerData pmd : allProjects) {
            if (!this.projectMatchesFilter(namePattern, ownerPattern, pmd)) continue;
            filteredProjects.add(pmd);
        }
    }

    @Override
    public void addListener(KeyListener kl) {
        this.projectNameField.addKeyListener(kl);
        this.projectOwnerField.addKeyListener(kl);
    }

    public void addItemListener(ItemListener itemListener) {
        this.projectStatusBox.addItemListener(itemListener);
        this.projectSharingBox.addItemListener(itemListener);
    }

    @Override
    public void emptyFilterData() {
        this.projectNameField.setText("");
        this.projectOwnerField.setText("");
        this.projectStatusBox.setSelectedItem(null);
        this.projectSharingBox.setSelectedItem(null);
    }

    public JLabel getProjectNameLabel() {
        return this.projectNameLabel;
    }

    public JPanel getProjectOwnerPanel() {
        return this.projectOwnerPanel;
    }

    public JLabel getProjectOwnerLabel() {
        return this.projectOwnerLabel;
    }

    public JLabel getProjectStatusLabel() {
        return this.projectStatusLabel;
    }

    public JLabel getProjectSharingLabel() {
        return this.projectSharingLabel;
    }

    public JPanel getSharingComboPanel() {
        return this.sharingComboPanel;
    }

    public JPanel getStatusComboPanel() {
        return this.statusComboPanel;
    }

    public JTextField getProjectNameField() {
        return this.projectNameField;
    }
}

