/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsmanager.proxy;

import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.models.ProjectSpaceAllocation;
import csbase.client.applications.projectsmanager.models.ProjectsManagerData;
import csbase.client.applications.projectsmanager.proxy.core.ProjectsManagerTask;
import csbase.logic.ProjectAdminInfo;
import java.util.List;

public class LocateMissingAllocatedProjectsTask
extends ProjectsManagerTask<Boolean> {
    public LocateMissingAllocatedProjectsTask(ProjectsManager projectsManager) {
        super(projectsManager);
    }

    protected void performTask() throws Exception {
        ProjectsManager projectsManager = this.getProjectsManager();
        List<ProjectsManagerData> projects = projectsManager.getAllProjects();
        ProjectAdminInfo[] prjAdmInfo = ProjectAdminInfo.getAll();
        if (prjAdmInfo == null) {
            this.setResult(false);
            return;
        }
        boolean found = false;
        for (ProjectAdminInfo p : prjAdmInfo) {
            found = false;
            for (int i = 0; i < projects.size(); ++i) {
                ProjectsManagerData pmd = projects.get(i);
                if (!p.getProjectName().equals(pmd.getProjectName())) continue;
                found = true;
                break;
            }
            if (found) continue;
            ProjectsManagerData tmp = new ProjectsManagerData(p.getProjectId(), p.getProjectName(), p.getOwnerId());
            tmp.setProjectSpaceAllocation(ProjectSpaceAllocation.WAITING_ALLOCATION);
            tmp.setRequestedSpace(p.getAreaRequestSize());
            projectsManager.addProject(tmp);
        }
        this.setResult(true);
    }
}

