/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.sgamonitor;

import csbase.client.applications.Application;
import csbase.client.applications.ApplicationComponentDialog;
import csbase.client.applications.sgamonitor.SGAMonitor;
import csbase.logic.CapacityType;
import csbase.logic.SGASet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Locale;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import tecgraf.javautils.core.lng.FormatUtils;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.SwingThreadDispatcher;

public class SimpleServerMonitor
extends ApplicationComponentDialog<SGAMonitor>
implements Observer {
    private String sgaName;
    private Application app;
    private JTextField serverNameField;
    private JTextField statusField;
    private JTextField platformField;
    private JTextField nProcessorsField;
    private JTextField cpuCapacityField;
    private JTextField ramMbField;
    private JTextField swapMbField;
    private JTextField ramField;
    private JTextField swapField;
    private JTextField cpuLoad1Field;
    private JTextField cpuLoad5Field;
    private JTextField cpuLoad15Field;

    public SimpleServerMonitor(SGAMonitor app) {
        super(app);
        this.app = app;
        this.buildInterface();
        this.setMinimumSize(new Dimension(500, 500));
        this.setVisible(false);
        this.pack();
    }

    public void updateSGAInfo(SGASet sga) {
        this.sgaName = sga.getName();
        Object application = this.getApplication();
        SwingThreadDispatcher.invokeLater((Runnable)new Runnable((Application)application, sga){
            final /* synthetic */ Application val$application;
            final /* synthetic */ SGASet val$sga;
            {
                this.val$application = application;
                this.val$sga = sGASet;
            }

            @Override
            public void run() {
                SimpleServerMonitor.this.setTitle(String.format(this.val$application.getString("sga.monitor"), SimpleServerMonitor.this.sgaName));
                SimpleServerMonitor.this.serverNameField.setText(this.val$sga.getName());
                SimpleServerMonitor.this.statusField.setText(this.val$application.getString("status." + this.val$sga.getStatus().toString()));
                SimpleServerMonitor.this.platformField.setText(this.val$sga.getPlatformId());
                SimpleServerMonitor.this.nProcessorsField.setText(Integer.toString(this.val$sga.getNumProcessors()));
                long cpuCapacity = this.val$sga.getCapacity(CapacityType.CPU);
                String cpuCapacityStr = "---";
                if (cpuCapacity >= 0L) {
                    cpuCapacityStr = Long.toString(cpuCapacity);
                }
                SimpleServerMonitor.this.cpuCapacityField.setText(cpuCapacityStr);
                SimpleServerMonitor.this.ramMbField.setText(SimpleServerMonitor.this.formatMemoryAndStorage(this.val$sga.getRAMMemoryInfoMb()));
                SimpleServerMonitor.this.swapMbField.setText(SimpleServerMonitor.this.formatMemoryAndStorage(this.val$sga.getSwapMemoryInfoMb()));
                SimpleServerMonitor.this.ramField.setText((int)(100.0 - this.val$sga.getRAMFreeMemory()) + " %");
                SimpleServerMonitor.this.swapField.setText((int)(100.0 - this.val$sga.getSwapFreeMemory()) + " %");
                SimpleServerMonitor.this.cpuLoad1Field.setText((int)this.val$sga.getCPULoad1() + " %");
                SimpleServerMonitor.this.cpuLoad5Field.setText((int)this.val$sga.getCPULoad5() + " %");
                SimpleServerMonitor.this.cpuLoad15Field.setText((int)this.val$sga.getCPULoad15() + " %");
            }
        });
    }

    private String formatMemoryAndStorage(int size) {
        long s = (long)size * 1024L * 1024L;
        return FormatUtils.formatSize((long)s, (int)2, (Locale)this.getLocale());
    }

    private void buildInterface() {
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        container.add((Component)this.createTopPanel(), new GBC(0, 0).insets(10, 10, 10, 10).both());
        container.add((Component)new JSeparator(0), new GBC(0, 1).right(10).left(10).horizontal());
        container.add((Component)this.createCenterPanel(), new GBC(0, 2).insets(10, 10, 10, 10).both());
        container.add((Component)new JSeparator(0), new GBC(0, 3).right(10).left(10).horizontal());
        container.add((Component)this.createBottomPanel(), new GBC(0, 4).insets(10, 10, 10, 10).both());
        JButton close = new JButton(((SGAMonitor)this.getApplication()).getString("button.close"));
        close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleServerMonitor.this.setVisible(false);
            }
        });
        container.add((Component)close, new GBC(0, 5).none().east().insets(0, 0, 10, 20));
    }

    private JPanel createTopPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        JLabel sgaNameLabel = new JLabel(this.app.getString("sga.name"));
        this.serverNameField = new JTextField();
        this.serverNameField.setEditable(false);
        panel.add((Component)sgaNameLabel, new GBC(0, 0).bottom(5).west().none());
        panel.add((Component)this.serverNameField, new GBC(1, 0).left(5).bottom(5).horizontal());
        JLabel statusLabel = new JLabel(this.app.getString("sga.status"));
        this.statusField = new JTextField();
        this.statusField.setEditable(false);
        panel.add((Component)statusLabel, new GBC(0, 1).bottom(5).west().none());
        panel.add((Component)this.statusField, new GBC(1, 1).left(5).bottom(5).horizontal());
        JLabel platformLabel = new JLabel(this.app.getString("sga.platform"));
        this.platformField = new JTextField();
        this.platformField.setEditable(false);
        panel.add((Component)platformLabel, new GBC(0, 2).bottom(5).west().none());
        panel.add((Component)this.platformField, new GBC(1, 2).left(5).bottom(5).horizontal());
        return panel;
    }

    private JPanel createCenterPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        JLabel cpuProcessingLabel = new JLabel(this.app.getString("cpu.processing"));
        panel.add((Component)cpuProcessingLabel, new GBC(0, 0).bottom(10).west().none());
        JLabel nProcessors = new JLabel(this.app.getString("number.of.processors"));
        this.nProcessorsField = new JTextField();
        this.nProcessorsField.setEditable(false);
        panel.add((Component)nProcessors, new GBC(0, 1).left(20).bottom(5).west().none());
        panel.add((Component)this.nProcessorsField, new GBC(1, 1).left(5).bottom(5).horizontal());
        JLabel cpuCapacityLabel = new JLabel(this.app.getString("cpu.capacity"));
        this.cpuCapacityField = new JTextField();
        this.cpuCapacityField.setEditable(false);
        panel.add((Component)cpuCapacityLabel, new GBC(0, 2).left(20).bottom(5).west().none());
        panel.add((Component)this.cpuCapacityField, new GBC(1, 2).left(5).bottom(5).horizontal());
        return panel;
    }

    private JPanel createBottomPanel() {
        JPanel left = new JPanel(new GridBagLayout());
        JLabel memoryLabel = new JLabel(this.app.getString("memory"));
        left.add((Component)memoryLabel, new GBC(0, 0).bottom(10).west().none());
        JLabel memorySizeLabel = new JLabel(this.app.getString("memory.size"));
        left.add((Component)memorySizeLabel, new GBC(0, 1).left(20).bottom(5).west().none());
        JLabel ramMbLabel = new JLabel(this.app.getString("memory.ram"));
        this.ramMbField = new JTextField();
        this.ramMbField.setEditable(false);
        left.add((Component)ramMbLabel, new GBC(0, 2).left(40).bottom(5).west().none());
        left.add((Component)this.ramMbField, new GBC(1, 2).left(5).bottom(5).horizontal());
        JLabel swapMbLabel = new JLabel(this.app.getString("memory.swap"));
        this.swapMbField = new JTextField();
        this.swapMbField.setEditable(false);
        left.add((Component)swapMbLabel, new GBC(0, 3).left(40).bottom(5).west().none());
        left.add((Component)this.swapMbField, new GBC(1, 3).left(5).bottom(5).horizontal());
        JLabel memoryLoadLabel = new JLabel(this.app.getString("memory.load"));
        left.add((Component)memoryLoadLabel, new GBC(0, 4).left(20).bottom(5).west().none());
        JLabel ramLabel = new JLabel(this.app.getString("memory.ram"));
        this.ramField = new JTextField();
        this.ramField.setEditable(false);
        left.add((Component)ramLabel, new GBC(0, 5).left(40).bottom(5).west().none());
        left.add((Component)this.ramField, new GBC(1, 5).left(5).bottom(5).horizontal());
        JLabel swapLabel = new JLabel(this.app.getString("memory.swap"));
        this.swapField = new JTextField();
        this.swapField.setEditable(false);
        left.add((Component)swapLabel, new GBC(0, 6).left(40).bottom(5).west().none());
        left.add((Component)this.swapField, new GBC(1, 6).left(5).bottom(5).horizontal());
        JPanel right = new JPanel(new GridBagLayout());
        JLabel cpuLoadLabel = new JLabel(this.app.getString("cpu.load"));
        right.add((Component)cpuLoadLabel, new GBC(0, 0).bottom(10).west().none());
        JLabel cpuLoad1Label = new JLabel(this.app.getString("cpu.load.1"));
        this.cpuLoad1Field = new JTextField();
        this.cpuLoad1Field.setEditable(false);
        right.add((Component)cpuLoad1Label, new GBC(0, 1).left(20).bottom(5).west().none());
        right.add((Component)this.cpuLoad1Field, new GBC(1, 1).left(5).bottom(5).horizontal());
        JLabel cpuLoad5Label = new JLabel(this.app.getString("cpu.load.5"));
        this.cpuLoad5Field = new JTextField();
        this.cpuLoad5Field.setEditable(false);
        right.add((Component)cpuLoad5Label, new GBC(0, 2).left(20).bottom(5).west().none());
        right.add((Component)this.cpuLoad5Field, new GBC(1, 2).left(5).bottom(5).horizontal());
        JLabel cpuLoad15Label = new JLabel(this.app.getString("cpu.load.15"));
        this.cpuLoad15Field = new JTextField();
        this.cpuLoad15Field.setEditable(false);
        right.add((Component)cpuLoad15Label, new GBC(0, 3).left(20).bottom(5).west().none());
        right.add((Component)this.cpuLoad15Field, new GBC(1, 3).left(5).bottom(5).horizontal());
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)left, new GBC(0, 0).bottom(10).horizontal());
        panel.add((Component)new JSeparator(1), new GBC(1, 0).insets(10, 10, 10, 10).vertical());
        panel.add((Component)right, new GBC(2, 0).bottom(10).horizontal());
        return panel;
    }

    @Override
    public void update(Observable o, Object arg) {
        List sgaSetList = (List)arg;
        for (SGASet sgaSet : sgaSetList) {
            if (!sgaSet.getName().equals(this.sgaName)) continue;
            this.updateSGAInfo(sgaSet);
        }
    }
}

