/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.externalresources;

import csbase.exception.CSBaseException;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import javax.jnlp.PrintService;
import javax.jnlp.ServiceManager;
import javax.jnlp.UnavailableServiceException;

public final class ExternalPrintService {
    private static final String UNAVAILABLE_SERVICE_MESSAGE = "O servi\u00e7o {0} n\u00e3o est\u00e1 dispon\u00edvel: {1}";
    private static final String PRINT_SERVICE_CLASS_NAME = "javax.jnlp.PrintService";
    private static ExternalPrintService instance;

    private ExternalPrintService() {
    }

    public static ExternalPrintService getInstance() {
        if (instance == null) {
            instance = new ExternalPrintService();
        }
        return instance;
    }

    public boolean isAvailable() {
        try {
            ServiceManager.lookup((String)PRINT_SERVICE_CLASS_NAME);
            return true;
        }
        catch (UnavailableServiceException e) {
            return false;
        }
    }

    private PrintService getPrintService() throws CSBaseException {
        try {
            return (PrintService)ServiceManager.lookup((String)PRINT_SERVICE_CLASS_NAME);
        }
        catch (UnavailableServiceException e) {
            throw new CSBaseException(UNAVAILABLE_SERVICE_MESSAGE, new Object[]{PRINT_SERVICE_CLASS_NAME, e.getMessage()});
        }
    }

    public PageFormat getDefaultPage() throws CSBaseException {
        PrintService printService = this.getPrintService();
        return printService.getDefaultPage();
    }

    public PageFormat showPageFormatDialog(PageFormat page) throws CSBaseException {
        PrintService printService = this.getPrintService();
        return printService.showPageFormatDialog(page);
    }

    public boolean print(Pageable document) throws CSBaseException {
        PrintService printService = this.getPrintService();
        return printService.print(document);
    }

    public boolean print(Printable painter) throws CSBaseException {
        PrintService printService = this.getPrintService();
        return printService.print(painter);
    }
}

