/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.facilities.algorithms.executor;

import csbase.client.facilities.algorithms.executor.CommandObserver;
import csbase.client.remote.srvproxies.messageservice.MessageProxy;
import csbase.logic.CommandNotification;
import csbase.util.messages.IMessageListener;
import csbase.util.messages.Message;

final class CommandRemoteListener
implements IMessageListener {
    private final CommandObserver[] observers;
    private final String cmdId;

    public CommandRemoteListener(String cmdId, CommandObserver[] observers) {
        this.cmdId = cmdId;
        this.observers = observers;
    }

    public CommandRemoteListener(String cmdId, CommandObserver observer) {
        this(cmdId, new CommandObserver[]{observer});
    }

    private boolean isInterested(CommandNotification data) {
        return this.cmdId.equals(data.getCommandId());
    }

    public void onMessagesReceived(Message ... messages) throws Exception {
        for (Message message : messages) {
            CommandNotification body = (CommandNotification)message.getBody();
            if (!this.isInterested(body)) {
                return;
            }
            for (CommandObserver commandObserver : this.observers) {
                commandObserver.notify(body);
            }
        }
        MessageProxy.removeListener(this);
    }
}

