/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.facilities.configurabletable;

import csbase.client.facilities.configurabletable.ConfigurableTableFactory;
import csbase.client.facilities.configurabletable.UI.ORIENTATION;
import csbase.client.facilities.configurabletable.UI.Panel4Tables;
import csbase.client.facilities.configurabletable.UI.SplitPane4Tables;
import csbase.client.facilities.configurabletable.UI.TabbedPane4Tables;
import csbase.client.facilities.configurabletable.UI.UI4Tables;
import csbase.client.facilities.configurabletable.model.Config;
import csbase.client.facilities.configurabletable.model.Panel;
import csbase.client.facilities.configurabletable.model.Splitpane;
import csbase.client.facilities.configurabletable.model.Tab;
import csbase.client.facilities.configurabletable.model.Table;
import csbase.client.facilities.configurabletable.model.TableRef;
import csbase.client.facilities.configurabletable.model.Tabs;
import csbase.client.facilities.configurabletable.stringprovider.IStringProvider;
import csbase.client.facilities.configurabletable.table.ConfigurableTable;
import javax.swing.JComponent;

public class UIFactory {
    private Config config;
    private IStringProvider stringProvider;
    private ConfigurableTableFactory tableFactory;

    public UIFactory(IStringProvider stringProvider) {
        this.stringProvider = stringProvider;
        if (this.stringProvider == null) {
            this.stringProvider = new IStringProvider(){

                @Override
                public String getString(String key) {
                    return key;
                }
            };
        }
    }

    public UIFactory(Config config, IStringProvider stringProvider) {
        this(stringProvider);
        this.config = config;
        this.tableFactory = new ConfigurableTableFactory(config, stringProvider);
    }

    public UI4Tables getUI4Tables(String id) {
        JComponent result = null;
        for (Object obj : this.config.getUI().getTabsAndPanelAndSplitpane()) {
            if (obj instanceof Panel && ((Panel)obj).getId().equals(id)) {
                result = this.getPanel(id);
                break;
            }
            if (obj instanceof Tabs && ((Tabs)obj).getId().equals(id)) {
                result = this.getTabbedPane(id);
                break;
            }
            if (!(obj instanceof Splitpane) || !((Splitpane)obj).getId().equals(id)) continue;
            result = this.getSplitPane(id);
            break;
        }
        return result;
    }

    public Panel4Tables getPanel(String id) {
        Panel4Tables panel = null;
        for (Object obj : this.config.getUI().getTabsAndPanelAndSplitpane()) {
            if (!(obj instanceof Panel) || !((Panel)obj).getId().equals(id)) continue;
            Panel panelConf = (Panel)obj;
            ORIENTATION orientation = ORIENTATION.value(panelConf.getOrientation());
            panel = new Panel4Tables(panelConf.getId(), orientation);
            for (TableRef tableRef : panelConf.getTableRef()) {
                Table tableConf = this.getTableConfById(tableRef.getId());
                try {
                    Class<?> clazz = Class.forName(tableConf.getDatatype());
                    ConfigurableTable<?> table = this.tableFactory.getTable(tableConf.getId(), clazz);
                    String label = this.stringProvider.getString(tableRef.getId());
                    panel.addTable(table, label, clazz);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("N\u00e3o existe a classe: " + tableConf.getDatatype());
                }
            }
        }
        panel.buildUI();
        return panel;
    }

    public TabbedPane4Tables getTabbedPane(String id) {
        TabbedPane4Tables tabbedPane = null;
        for (Object obj : this.config.getUI().getTabsAndPanelAndSplitpane()) {
            if (!(obj instanceof Tabs) || !((Tabs)obj).getId().equals(id)) continue;
            Tabs tabsConf = (Tabs)obj;
            tabbedPane = new TabbedPane4Tables(tabsConf.getId());
            for (Tab tabConf : tabsConf.getTab()) {
                ORIENTATION orientation = ORIENTATION.value(tabConf.getOrientation());
                String tabTitle = this.stringProvider.getString(tabConf.getId());
                tabbedPane.addTab(tabTitle, orientation);
                for (TableRef tableRef : tabConf.getTableRef()) {
                    Table tableConf = this.getTableConfById(tableRef.getId());
                    try {
                        Class<?> clazz = Class.forName(tableConf.getDatatype());
                        ConfigurableTable<?> table = this.tableFactory.getTable(tableConf.getId(), clazz);
                        String label = this.stringProvider.getString(tableRef.getId());
                        tabbedPane.addTable(tabTitle, table, label, clazz);
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException("N\u00e3o existe a classe: " + tableConf.getDatatype());
                    }
                }
            }
            tabbedPane.buildUI();
        }
        return tabbedPane;
    }

    public SplitPane4Tables getSplitPane(String id) {
        SplitPane4Tables splitPane = null;
        for (Object obj : this.config.getUI().getTabsAndPanelAndSplitpane()) {
            if (!(obj instanceof Splitpane) || !((Splitpane)obj).getId().equals(id)) continue;
            Splitpane splitpaneConf = (Splitpane)obj;
            ORIENTATION orientation = ORIENTATION.value(splitpaneConf.getOrientation());
            splitPane = new SplitPane4Tables(splitpaneConf.getId(), orientation);
            for (TableRef tableRef : splitpaneConf.getTableRef()) {
                Table tableConf = this.getTableConfById(tableRef.getId());
                try {
                    Class<?> clazz = Class.forName(tableConf.getDatatype());
                    ConfigurableTable<?> table = this.tableFactory.getTable(tableConf.getId(), clazz);
                    String label = this.stringProvider.getString(tableRef.getId());
                    splitPane.addTable(table, label, clazz);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("N\u00e3o existe a classe: " + tableConf.getDatatype());
                }
            }
        }
        splitPane.buildUI();
        return splitPane;
    }

    private Table getTableConfById(String tableId) {
        for (Table table : this.config.getTables().getTable()) {
            if (!table.getId().equals(tableId)) continue;
            return table;
        }
        return null;
    }
}

