/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.remote.srvproxies;

import csbase.client.desktop.DesktopComponentFrame;
import csbase.client.desktop.DesktopFrame;
import csbase.client.desktop.DesktopTask;
import csbase.client.kernel.ClientException;
import csbase.client.remote.NotificationObserver;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.User;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.NotificationServiceInterface;
import java.awt.Window;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observer;
import tecgraf.javautils.core.lng.LNG;

public class NotificationProxy {
    private static Hashtable<Object, NotificationObserver> userHash = new Hashtable();

    static void killUserObserver(Object userId) throws RemoteException {
        NotificationObserver observer = userHash.get(userId);
        if (observer != null) {
            observer.decRefs();
            if (observer.hasNoRefs()) {
                userHash.remove(userId);
                observer.uninstall();
            }
        }
    }

    static NotificationObserver getUserObserver(Object userId) throws RemoteException {
        NotificationObserver observer = userHash.get(userId);
        if (observer == null) {
            observer = new NotificationObserver();
            userHash.put(userId, observer);
        }
        observer.incRefs();
        return observer;
    }

    private static NotificationServiceInterface getService() {
        return ClientRemoteLocator.notificationService;
    }

    private static void showError(String msg) {
        DesktopFrame mainFrame = DesktopFrame.getInstance();
        if (mainFrame == null) {
            return;
        }
        DesktopComponentFrame jFrame = mainFrame.getDesktopFrame();
        if (jFrame == null) {
            return;
        }
        StandardErrorDialogs.showErrorDialog((Window)jFrame, LNG.get((String)"notification.check.title"), msg);
    }

    public static boolean autoNotify(String content) {
        User loggedUser = User.getLoggedUser();
        if (loggedUser != null) {
            Object[] ids = new Object[]{loggedUser.getId()};
            return NotificationProxy.notifyTo(ids, content, false, false);
        }
        return false;
    }

    public static boolean notifyTo(final Object[] userIds, final String content, final boolean mustPopUp, final boolean volFlag) {
        DesktopFrame mainFrame = DesktopFrame.getInstance();
        final NotificationServiceInterface service = NotificationProxy.getService();
        if (mainFrame == null || service == null) {
            NotificationProxy.showError(LNG.get((String)"notification.no.server.error"));
            return false;
        }
        DesktopTask task = new DesktopTask(){

            @Override
            public void performTask() throws Exception {
                service.notifyTo(userIds, content, mustPopUp, volFlag);
            }
        };
        task.start(mainFrame.getDesktopFrame(), LNG.get((String)"notification.send.title"), LNG.get((String)"notification.send.message"));
        Exception exception = task.getException();
        if (exception != null) {
            NotificationProxy.showError(exception.getMessage());
            return false;
        }
        return true;
    }

    public static void addUserObserver(Observer observer, Object userId) {
        try {
            NotificationObserver not = NotificationProxy.getUserObserver(userId);
            not.addObserver(observer);
            not.addUserObserver(userId);
        }
        catch (Exception e) {
            NotificationProxy.showError(e.getMessage());
        }
    }

    public static void deleteUserObserver(Observer observer, Object userId) {
        try {
            NotificationObserver not = NotificationProxy.getUserObserver(userId);
            not.deleteUserObserver(userId);
            not.deleteObserver(observer);
            NotificationProxy.killUserObserver(userId);
        }
        catch (Exception e) {
            NotificationProxy.showError(e.getMessage());
        }
    }

    public static void resetObservers() throws Exception {
        NotificationServiceInterface service = NotificationProxy.getService();
        if (service == null) {
            throw new ClientException(LNG.get((String)"notification.no.server.error"));
        }
        Enumeration<Object> e = userHash.keys();
        while (e.hasMoreElements()) {
            Object uid = e.nextElement();
            NotificationObserver not = userHash.get(uid);
            not.deleteUserObserver(uid);
            not.deleteObservers();
            not.uninstall();
        }
        userHash = new Hashtable();
    }
}

