/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.sga;

import csbase.client.kernel.ClientException;
import csbase.client.util.sga.SGASelectionPanel;
import csbase.logic.SGASet;
import csbase.logic.algorithms.AlgorithmConfigurator;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import javax.swing.JComboBox;

public class SGASingleSelectionPanel
extends SGASelectionPanel {
    private JComboBox sgaServerComboBox = this.makeSGAServerComboBox();

    public SGASingleSelectionPanel(AlgorithmConfigurator configurator) {
        super(configurator);
    }

    @Override
    public Collection<SGASet> getManualServerCollection() {
        LinkedList<SGASet> selectedServerCollection = new LinkedList<SGASet>();
        SGASet selectedServer = this.getSelectedServer();
        if (selectedServer != null) {
            selectedServerCollection.add(selectedServer);
        }
        return Collections.unmodifiableCollection(selectedServerCollection);
    }

    @Override
    public SGASet getManualSelectedServer() {
        return (SGASet)this.sgaServerComboBox.getSelectedItem();
    }

    @Override
    public boolean hasAvailableServers() {
        return this.sgaServerComboBox.getItemCount() != 0;
    }

    @Override
    public boolean isSelectionReady() {
        return this.hasAvailableServers();
    }

    @Override
    public void populateGUIComponents() {
        this.removeAll();
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        this.add((Component)this.platformFilterPanel, c);
        c.insets = new Insets(2, 2, 2, 2);
        c.gridx = 1;
        ++c.gridy;
        this.add((Component)this.automaticServerRadioButton, c);
        ++c.gridy;
        this.add((Component)this.manualServerRadioButton, c);
        c.weightx = 0.0;
        ++c.gridy;
        c.insets = new Insets(2, 20, 2, 2);
        this.add((Component)this.sgaServerComboBox, c);
        this.revalidate();
        this.updateEnabledServers();
    }

    @Override
    public void updateEnabledServers() {
        if (this.hasAvailableServers()) {
            if (this.manualServerRadioButton.isSelected()) {
                this.sgaServerComboBox.setEnabled(true);
            } else {
                this.sgaServerComboBox.setEnabled(false);
            }
            this.manualServerRadioButton.setEnabled(true);
            this.automaticServerRadioButton.setEnabled(true);
        } else {
            this.manualServerRadioButton.setEnabled(false);
            this.automaticServerRadioButton.setEnabled(false);
            this.sgaServerComboBox.setEnabled(false);
        }
    }

    @Override
    public void reloadSGAs() {
        try {
            this.sgaServerComboBox.removeAllItems();
            for (SGASet sgaSet : this.loadServers()) {
                this.sgaServerComboBox.addItem(sgaSet);
            }
            this.updateEnabledServers();
        }
        catch (ClientException e) {
            e.printStackTrace();
        }
    }

    private JComboBox makeSGAServerComboBox() {
        JComboBox<SGASet> combo = null;
        try {
            combo = new JComboBox<SGASet>(this.loadServers());
            combo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    SGASingleSelectionPanel.this.fireChangedServer();
                }
            });
        }
        catch (ClientException e) {
            e.printStackTrace();
        }
        return combo;
    }
}

