/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.table;

import csbase.logic.ProgressData;
import java.awt.Component;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class ProgressCellRenderer
extends DefaultTableCellRenderer {
    private JProgressBar progressBar;
    private String emptyValue;

    public ProgressCellRenderer() {
        this((String)null);
    }

    public ProgressCellRenderer(String emptyValue) {
        this.emptyValue = emptyValue;
        this.progressBar = new JProgressBar();
        this.progressBar.setStringPainted(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value == null) {
            return super.getTableCellRendererComponent(table, this.emptyValue, isSelected, hasFocus, row, column);
        }
        if (value instanceof ProgressData) {
            ProgressData valueData = (ProgressData)value;
            Double numberValue = valueData.getValue();
            String description = valueData.getDescription();
            if (numberValue == null || numberValue.isNaN()) {
                if (description == null) {
                    description = this.emptyValue;
                }
                return super.getTableCellRendererComponent(table, description, isSelected, hasFocus, row, column);
            }
            this.progressBar.setString(description);
            this.setValue(valueData.getValue());
        } else {
            Number number = (Number)value;
            ProgressData data = new ProgressData(Double.valueOf(number.doubleValue()));
            this.setValue(number);
            this.progressBar.setString(data.getFormattedValue());
        }
        this.setEnabled(table.isEnabled());
        return this.progressBar;
    }

    private void setValue(Number number) {
        if (number != null && !number.equals(Double.NaN)) {
            this.progressBar.setValue(number.intValue());
        }
    }
}

