/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.flowapplication.actions;

import csbase.client.applications.ApplicationImages;
import csbase.client.applications.flowapplication.FlowApplication;
import csbase.client.applications.flowapplication.actions.FlowApplicationAction;
import csbase.client.applications.flowapplication.graph.Graph;
import csbase.client.applications.flowapplication.graph.GraphElement;
import csbase.client.applications.flowapplication.graph.utils.GraphUpdateOperation;
import csbase.client.util.StandardErrorDialogs;
import java.awt.Window;
import java.awt.event.ActionEvent;

public class UpdateAllVersionsAction
extends FlowApplicationAction {
    public UpdateAllVersionsAction(FlowApplication application) {
        super(application, ApplicationImages.ICON_REFRESH_16);
        this.setEnabled(false);
    }

    @Override
    public void handleActionPerformed(ActionEvent event) {
        FlowApplication application = (FlowApplication)this.getApplication();
        Graph graph = application.getWorkspace().getGraph();
        GraphUpdateOperation operation = new GraphUpdateOperation(graph);
        boolean result = operation.update();
        if (!result) {
            StandardErrorDialogs.showErrorDialog((Window)application.getApplicationFrame(), this.getString("UpdateAllVersionsAction.error", new Object[0]));
        }
        this.updateEnabledStatus(graph);
    }

    @Override
    public void wasElementRemoved(Graph graph, GraphElement element) {
        this.updateEnabledStatus(graph);
    }

    @Override
    public void wasElementCreated(Graph graph, GraphElement element) {
        this.updateEnabledStatus(graph);
    }

    @Override
    public void wasChangedWorkspace(Graph graph) {
        this.updateEnabledStatus(graph);
    }

    private void updateEnabledStatus(Graph graph) {
        this.setEnabled(GraphUpdateOperation.hasNewerVersion(graph));
    }
}

