/*
 * $Id:$
 */

package csbase.client.algorithms.commands.view;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;
import csbase.logic.ClientProjectFile;
import csbase.logic.CommandInfo;

/**
 * Aba de logs adicionais de um comando, que consolida arquivos de log que
 * complementam os de sada-padro. Os arquivos de log apresentados nessa aba
 * so configurveis por sistema.
 */
public class ConsolidatedLogsTab extends AbstractConsolidatedLogTab {

  /**
   * Ttulo da aba.
   */
  private String title;
  /**
   * Arquivos mostrados na aba.
   */
  private SortedSet<ClientProjectFile> files;

  /**
   * Construtor
   *
   * @param commandInfo Informaes sobre o comando cujo log deve ser
   *        apresentado.
   * @param files Arquivos que devero ser mostrados na aba.
   * @param title Ttulo da aba.
   */
  public ConsolidatedLogsTab(CommandInfo commandInfo,
    Set<ClientProjectFile> files, String title) {
    super(commandInfo);
    this.files = new TreeSet<ClientProjectFile>(files);
    this.title = title;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected String getTitle() {
    return title;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void loadLog() {
    textArea.setText("");
    try {
      final String logsContent = readFiles(files);
      textArea.setText(logsContent);
    }
    catch (final IOException e) {
      String errorTitle = LNG.get("ConsolidatedLogsTab.error.title.loadFailed");
      String errorMsg =
        LNG.get("ConsolidatedLogsTab.error.msg.loadFailed",
          new Object[] { getCommand().getId() });
      StandardDialogs.showErrorDialog(this.getParent(), errorTitle, errorMsg);
    }
  }

  /**
   * L e concatena o contedo de mltiplos arquivos para uma String.
   *
   * @param files Os arquivos a serem lidos.
   * @return O contedo dos arquivos.
   * @throws IOException em caso de falha de I/O
   */
  public String readFiles(final Set<ClientProjectFile> files)
    throws IOException {
    final StringWriter writer = new StringWriter();
    final PrintWriter printWriter = new PrintWriter(writer);
    if (files != null) {
      for (final ClientProjectFile file : files) {
        InputStream inputStream = null;
        BufferedReader bufferedReader = null;
        try {
          printWriter.print("\n");
          printWriter.printf("---- %s ----", file.getName());
          if (file.exists()) {
            printWriter.print("\n");
            inputStream = file.getInputStream();
            bufferedReader =
              new BufferedReader(new InputStreamReader(inputStream));
            String line = bufferedReader.readLine();
            while (line != null) {
              printWriter.println(line);
              line = bufferedReader.readLine();
            }
          }
          else {
            String errorMsg =
              LNG.get("ConsolidatedLogsTab.error.msg.fileNotFound");
            printWriter.print(" [" + errorMsg + "]\n");
          }
        }
        finally {
          if (bufferedReader != null) {
            bufferedReader.close();
          }
          else if (inputStream != null) {
            inputStream.close();
          }
        }
      }
    }
    return writer.getBuffer().toString();
  }

}
