package csbase.client.applications;

import java.awt.event.ActionEvent;

import csbase.client.applicationmanager.ApplicationException;
import csbase.client.applicationmanager.ApplicationManager;
import csbase.client.applicationmanager.ApplicationType;
import csbase.client.preferences.PreferenceCategory;

/**
 * Ao genrica que permite a aplicao editar as preferncias do usurio.
 * 
 * @author Tecgraf
 */
public class ApplicationEditPrefAction extends
  ApplicationStandardAction<Application> {

  /** Categoria a ser editada. */
  private PreferenceCategory pc;

  /**
   * Construtor padro.
   * 
   * @param application - aplicao.
   */
  public ApplicationEditPrefAction(Application application) {
    super(application);
  }

  /**
   * Construtor padro.
   * 
   * @param application - aplicao.
   * @param copy - cpia da categoria.
   */
  public ApplicationEditPrefAction(Application application,
    PreferenceCategory copy) {
    super(application);
    this.pc = copy;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionPerformed(ActionEvent e) {
    if (pc == null) {
      Application application = getApplication();
      pc = application.getPreferences();
    }

    ApplicationManager am = ApplicationManager.getInstance();
    try {
      // TODO - refatorar a maneira de obtermos o identificador da aplicao.
      ApplicationType app = am.runApplication("preferenceviewer");
      app.sendMessage(Application.PREFERENCE_MESSAGE, pc, null);
    }
    catch (ApplicationException exception) {
      throw new RuntimeException(exception);
    }
  }
}
