package csbase.client.applications.fileexchanger.actions;

import javax.swing.Action;

import csbase.client.applications.fileexchanger.FileExchanger;
import csbase.client.applications.fileexchanger.actions.core.FileExchangerAction;
import csbase.client.applications.fileexchanger.logic.ExchangeMode;
import csbase.client.applications.fileexchanger.logic.FileExchangerConfiguration;

/**
 * Ao para definir o modo de transmisso.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class TransferModeAction extends FileExchangerAction {

  /**
   * Modo de ajuste
   */
  final private ExchangeMode transferMode;

  /**
   * Construtor
   * 
   * @param fileExchanger aplicao
   * @param transferMode modo a ser ajustado.
   */
  public TransferModeAction(FileExchanger fileExchanger,
    ExchangeMode transferMode) {
    super(fileExchanger);
    this.transferMode = transferMode;
    putValue(Action.NAME, transferMode.getName());
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionDone() {
    final FileExchanger fileExchanger = getApplication();
    final FileExchangerConfiguration configuration =
      fileExchanger.getConfiguration();
    configuration.setTransferMode(transferMode);
  }
}
