package csbase.client.applications.flowapplication.actions;

import java.awt.event.ActionEvent;

import csbase.client.applicationmanager.ApplicationException;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.flowapplication.FlowApplication;
import csbase.logic.ClientProjectFile;

/**
 * Ao salvar grafo em projeto.
 */
public final class SaveAsProjectAction extends FlowApplicationAction {
  /**
   * Cria a ao.
   *
   * @param application A aplicao.
   */
  public SaveAsProjectAction(FlowApplication application) {
    super(application, ApplicationImages.ICON_SAVEAS_16);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void handleActionPerformed(ActionEvent ev) {
    final FlowApplication app = getApplication();
    try {
      final ClientProjectFile file = app.browseFileSave(app
        .getDefaultFileType());
      app.saveAsGraph(file);
    }
    catch (final ApplicationException e) {
      app.showExceptionStack(e);
    }
  }
}
