/**
 * $Id: SendLogFilesDialog.java 146656 2013-11-07 17:13:39Z mjulia $
 */
package csbase.client.applications.logadministration;

import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.GUIUtils;
import csbase.client.desktop.RemoteTask;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.LogAdministrationServiceInterface;

/**
 * Dilogo para efetuar o envio de arquivos de log por email
 * 
 * @author Tecgraf
 */
public class SendLogFilesDialog extends LogFileDialog {

  /**
   * Construtor
   * 
   * @param application a aplicao que abriu o dilogo
   */
  public SendLogFilesDialog(LogAdministration application) {
    super(application);
    this.setTitle(getString("SendLogFilesDialog.title"));
    buildFrame();
    addComponentListener(new ComponentAdapter() {
      @Override
      public void componentShown(ComponentEvent e) {
        body.setText("");
        admCheck.setSelected(false);
        supCheck.setSelected(false);
      }
    });
  }

  /**
   * rea de texto para escrever o corpo do email
   */
  private JTextArea body = null;

  /**
   * Check box indicativo para enviar email ao administrador
   */
  private JCheckBox admCheck = null;

  /**
   * Check box indicativo para enviar email ao suporte
   */
  private JCheckBox supCheck = null;

  /**
   * Caminhos completos dos arquivos selecionados
   */
  private String[] filePaths;

  /**
   * Ao para enviar email
   */
  SendEmailAction sendEmailAction = new SendEmailAction();

  /**
   * Ao para fechar o dilogo
   */
  CancelAction cancelAction = new CancelAction();

  /*****************************************************************************
   * Construtores da interface
   ****************************************************************************/

  /**
   * Contri a frame do dilogo
   */
  private void buildFrame() {
    this.getContentPane().setLayout(new GridBagLayout());
    this.setSize(300, 300);

    this.add(buildBodyPanel(), new GBC(0, 0).both().insets(5, 5, 5, 5));
    this.add(buildCheckPanel(), new GBC(0, 1).horizontal().insets(5, 5, 5, 5));
    this.add(buildButtonPanel(), new GBC(0, 2).horizontal().insets(5, 5, 5, 5));
  }

  /**
   * Contri o painel com a rea de texto do corpo da mensagem
   * 
   * @return painel da rea de texto
   */
  private JPanel buildBodyPanel() {
    JPanel bobyPanel = new JPanel(new GridBagLayout());

    tecgraf.javautils.gui.BorderUtil.setTitledBorder(bobyPanel,
      getString("SendLogFilesDialog.email.body"));

    body = new JTextArea();
    JScrollPane bodyScrollPabe = new JScrollPane(body);
    bobyPanel.add(bodyScrollPabe, new GBC(0, 0).both().insets(5, 5, 5, 5));

    return bobyPanel;
  }

  /**
   * Contri o painel com o botes
   * 
   * @return painel com os botes
   */
  private JPanel buildButtonPanel() {
    JPanel buttonPanel = new JPanel(new GridBagLayout());

    JButton sendEmailButon =
      new JButton(getString("SendLogFilesDialog.action.send"));
    sendEmailButon.addActionListener(sendEmailAction);

    JButton cancelButton =
      new JButton(getString("SendLogFilesDialog.action.cancel"));
    cancelButton.addActionListener(cancelAction);

    final JComponent[] cmps = new JComponent[] { sendEmailButon, cancelButton };
    GUIUtils.matchPreferredSizes(cmps);

    buttonPanel.add(sendEmailButon, new GBC(0, 0).none().insets(0, 0, 0, 0));
    buttonPanel.add(cancelButton, new GBC(1, 0).none().insets(0, 0, 0, 0));

    return buttonPanel;
  }

  /**
   * Contri o painel com as check boxes
   * 
   * @return painel com as check boxes
   */
  private JPanel buildCheckPanel() {
    JPanel checkPanel = new JPanel(new GridBagLayout());

    tecgraf.javautils.gui.BorderUtil.setTitledBorder(checkPanel,
      getString("SendLogFilesDialog.checkbox.panel.title"));

    admCheck = new JCheckBox(getString("SendLogFilesDialog.checkbox.adm"));
    supCheck = new JCheckBox(getString("SendLogFilesDialog.checkbox.sup"));
    checkPanel.add(admCheck, new GBC(0, 0).none().insets(0, 0, 0, 0));
    checkPanel.add(supCheck, new GBC(1, 0).none().insets(0, 0, 0, 0));

    return checkPanel;
  }

  /*****************************************************************************
   * Aes
   ****************************************************************************/

  /**
   * Ao para enviar email com os arquivos de log
   * 
   * @author Tecgraf
   */
  private class SendEmailAction implements ActionListener {

    /**
     * {@inheritDoc}
     */
    @Override
    public void actionPerformed(ActionEvent arg0) {
      String[] paths = new String[filesInfo.length];

      for (int i = 0; i < filesInfo.length; i++) {
        paths[i] = filesInfo[i].path;
      }

      filePaths = paths;

      if (admCheck.isSelected()) {
        SendToAdminTask task = new SendToAdminTask();
        if (!task.execute(getApplication().getApplicationFrame(),
          getString("SendLogFilesDialog.sendlogfilestask.message"),
          getString("SendLogFilesDialog.sendlogfilestask.title"))) {
          getApplication().showError(
            getString("SendLogFilesDialog.sendlog.error.msg"));
        }
        Boolean result = task.getResult();
        if (!result.booleanValue()) {
          getApplication().showError(
            getString("SendLogFilesDialog.sendlog.error.msg"));
        }
      }
      if (supCheck.isSelected()) {
        SendToSupTask task = new SendToSupTask();
        if (!task.execute(getApplication().getApplicationFrame(),
          getString("SendLogFilesDialog.sendlogfilestask.message"),
          getString("SendLogFilesDialog.sendlogfilestask.title"))) {
          getApplication().showError(
            getString("SendLogFilesDialog.sendlog.error.msg"));
        }
        Boolean result = task.getResult();

        if (!result.booleanValue()) {
          getApplication().showError(
            getString("SendLogFilesDialog.sendlog.error.msg"));
        }
      }

      clearSelectedFiles();

      setVisible(false);
    }
  }

  /**
   * Ao para fechar o dilogo
   * 
   * @author Tecgraf
   */
  private class CancelAction implements ActionListener {

    /**
     * {@inheritDoc}
     */
    @Override
    public void actionPerformed(ActionEvent arg0) {
      clearSelectedFiles();
      setVisible(false);
    }
  }

  /*****************************************************************************
   * Tarefas remote
   ****************************************************************************/

  /**
   * Tarefa remota para enviar email para o administrador
   * 
   * @author Tecgraf
   */
  private class SendToAdminTask extends RemoteTask<Boolean> {

    /**
     * {@inheritDoc}
     */
    @Override
    protected void performTask() throws Exception {
      LogAdministrationServiceInterface logAdministrationService =
        ClientRemoteLocator.logAdministrationService;
      setResult(logAdministrationService.sendlLogFilesToAdmin(
        appendNewLine(body.getText()), filePaths));
    }
  }

  /**
   * Tarefa remota para enviar email para o suporte
   * 
   * @author Tecgraf
   */
  private class SendToSupTask extends RemoteTask<Boolean> {

    /**
     * {@inheritDoc}
     */
    @Override
    protected void performTask() throws Exception {
      LogAdministrationServiceInterface logAdministrationService =
        ClientRemoteLocator.logAdministrationService;
      setResult(logAdministrationService.sendlLogFilesToSuport(
        appendNewLine(body.getText()), filePaths));
    }
  }

  /*****************************************************************************
   * utilitrios
   ****************************************************************************/

  /**
   * Adiciona novas linhas ao final de uma string
   * 
   * @author Tecgraf
   * @param str string a concatenar
   * @return string concatenada
   */
  private String appendNewLine(String str) {
    return str + "\n\n";
  }
}
