package csbase.client.applications.sgamonitor.columns;

import csbase.client.facilities.configurabletable.column.AbstractConfigurableColumn;
import csbase.client.facilities.configurabletable.stringprovider.IStringProvider;
import csbase.logic.SGAInfo;

/**
 * Coluna que exibe o nome de um n de cluster.
 * 
 * @author Tecgraf
 */
public class NodeNameColumn extends AbstractConfigurableColumn<SGAInfo> {

  /**
   * Construtor padro.
   * 
   * @param id - identificador da coluna.
   * @param visible - visibilidade da coluna.
   * @param stringProvider - utilizado para obter o nome da coluna
   *        internacionalizada.
   * @param align - alinhamento da coluna.
   */

  public NodeNameColumn(String id, Boolean visible,
    IStringProvider stringProvider, Integer align) {
    super(id, visible, stringProvider, align);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Class<?> getColumnClass() {
    return String.class;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getColumnName() {
    return getString(getId());
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object getValue(SGAInfo obj) {
    return obj.getHostName();
  }
}
