package csbase.client.csdk.v2.application.manager;

import csbase.client.applicationmanager.ApplicationManager;
import csbase.client.applicationmanager.ApplicationType;
import csbase.client.csdk.v2.core.CSDKAbstractContext;
import csdk.v2.api.application.ApplicationException;
import csdk.v2.api.application.IMessage;
import csdk.v2.api.application.manager.IApplicationManagerContext;
import tecgraf.javautils.core.lng.LNG;

/**
 * Implementao do contexto de gerncia de aplicaes do CSDK no ambiente, que
 * permite basicamente a interao com outras instncias de aplicao.
 */
public class CSDKApplicationManagerContext extends CSDKAbstractContext
  implements IApplicationManagerContext {

  /**
   * Identificador da instncia da aplicao.
   */
  private final String instanceId;

  /**
   * Construtor.
   *
   * @param instanceId identificador da instncia da aplicao.
   */
  public CSDKApplicationManagerContext(String instanceId) {
    this.instanceId = instanceId;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean isApplicationRunning(String instanceId) {
    ApplicationManager manager = ApplicationManager.getInstance();
    return manager.getApplicationInstance(instanceId) != null;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void killApplication(String instanceId) throws ApplicationException {
    ApplicationManager manager = ApplicationManager.getInstance();
    ApplicationType senderApp = manager.getApplicationInstance(instanceId);
    if (senderApp != null) {
      if (!senderApp.closeApplication()) {
        String errorMsg = LNG.get(
          CSDKApplicationManagerContext.class.getSimpleName() + ".kill.error");
        throw new ApplicationException(errorMsg);
      }
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void sendAsyncMessage(String appInstanceId,
    IMessage message) throws ApplicationException {
    ApplicationManager manager = ApplicationManager.getInstance();
    manager
      .sendAsyncMessage(appInstanceId, message.getType(), message.getValue(),
        instanceId);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void broadcastAsyncMessage(
    IMessage message) throws ApplicationException {
    ApplicationManager manager = ApplicationManager.getInstance();
    manager
      .broadcastAsyncMessage(message.getType(), message.getValue(), instanceId);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object sendSyncMessage(String appInstanceId,
    IMessage message) throws ApplicationException {
    ApplicationManager manager = ApplicationManager.getInstance();
    return manager
      .sendSyncMessage(appInstanceId, message.getType(), message.getValue(),
        instanceId);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String runApplication(String id) throws ApplicationException {
    final ApplicationManager manager = ApplicationManager.getInstance();
    try {
      if (!manager.hasApplicationRegistry(id)) {
        return null;
      }
      ApplicationType app = manager.runApplication(id);
      if (app == null) {
        return null;
      }
      return app.getInstanceId();
    }
    catch (csbase.client.applicationmanager.ApplicationException e) {
      throw new ApplicationException(e);
    }
  }
}
