/**
 * $Id$
 */

package csbase.client.remote;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Observable;

import csbase.remote.RemoteEvent;
import csbase.remote.RemoteObserver;
import csbase.remote.SchedulerServiceInterface;

/**
 * Permite aos clientes observar mudanas no agendador de comandos.
 * 
 * @author Tecgraf/PUC-Rio
 * @deprecated O estados dos comandos so enviados diretamente do servio para
 *             as aplicaes clientes via MessageService. Este observador no
 *             tem mais utilizada e dever ser removido.
 */
@Deprecated
public class SchedulerObserver extends Observable implements RemoteObserver {

  /**
   * Instncia nica do observador
   */
  private static SchedulerObserver instance = null;

  /**
   * Cria um observador remoto do servio de agendamento de comandos. Exporta
   * esse objeto para o sistema rmi.
   * 
   * @throws RemoteException no caso de falha de RMI.
   */
  protected SchedulerObserver() throws RemoteException {
    super();
    install();
  }

  /**
   * Cria um singleton desta classe.
   * 
   * @throws RemoteException Em caso de erro de RMI.
   */
  public static void start() throws RemoteException {
    if (instance != null) {
      return;
    }
    instance = new SchedulerObserver();
  }

  /**
   * Desinstala o observador do registro do RMI.
   * 
   * @throws RemoteException Em caso de erro de RMI.
   */
  public static void stop() throws RemoteException {
    if (instance == null) {
      return;
    }
    instance.uninstall();
  }

  /**
   * <p>
   * Obtm o singleton.
   * </p>
   * 
   * <p>
   * Ele no cria o singleton. Para cri-lo, utilize o mtodo {@link #start()}.
   * </p>
   * 
   * @return O singleton.
   */
  public static SchedulerObserver getInstance() {
    if (instance == null) {
      throw new IllegalStateException(
        "A instncia do observador no foi criada.\n"
          + "Chame o mtodo start primeiro.\n");
    }
    return instance;
  }

  /**
   * Registra no servidor um observador.
   */
  @Override
  public void install() throws RemoteException {
    UnicastRemoteObject.exportObject(this, 0);
    ClientRemoteMonitor.getInstance().addObserver(
      SchedulerServiceInterface.SERVICE_NAME, this, null);
  }

  /**
   * Remove do servidor o registro desse observador.
   */
  @Override
  public void uninstall() throws RemoteException {
    ClientRemoteMonitor.getInstance().deleteObserver(
      SchedulerServiceInterface.SERVICE_NAME, this, null);
    instance = null;
    UnicastRemoteObject.unexportObject(this, true);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void update(RemoteEvent event) throws RemoteException {
    setChanged();
    notifyObservers(event);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void update(RemoteEvent[] events) throws RemoteException {
    for (int i = 0; i < events.length; i++) {
      update(events[i]);
    }
  }
}
