/*
 * MailProxy.java
 * 
 * @author Andr Luiz Clinio $Revision: 150777 $ - $Date: 2010-07-13 10:39:50
 * -0300 (Tue, 13 Jul 2010) $
 */
package csbase.client.remote.srvproxies;

import javax.swing.JFrame;

import tecgraf.javautils.core.lng.LNG;
import csbase.client.desktop.DesktopFrame;
import csbase.client.desktop.DesktopTask;
import csbase.client.util.StandardErrorDialogs;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.MailServiceInterface;

/**
 * Classe que modela um proxy Cliente/MailService.
 * 
 * @author Andr Luiz Clinio e Leonardo Barros
 */
public class MailProxy {

  /**
   * Mtodo de aviso de erro
   * 
   * @param msg mensagem a ser exibida.
   */
  private static void showError(final String msg) {
    final DesktopFrame mainFrame = DesktopFrame.getInstance();
    if (mainFrame == null) {
      return;
    }

    final JFrame jFrame = mainFrame.getDesktopFrame();
    if (jFrame == null) {
      return;
    }

    final String title = LNG.get("MAIL_SEND_TITLE");
    StandardErrorDialogs.showErrorDialog(jFrame, title, msg);
  }

  /**
   * Mtodo para notifificao a um usurio.
   * 
   * @param senderName string de identificao do remetente
   * @param userId identificador do usurio destino
   * @param content contedo da mensagem
   * @param showMsg exibio de mensagem.
   * @return flag booleano de sucesso da operao
   */
  public static boolean mailTo(final String senderName, final Object userId,
    final String content, final boolean showMsg) {
    final MailServiceInterface mailService = ClientRemoteLocator.mailService;
    final DesktopFrame mainFrame = DesktopFrame.getInstance();
    if ((mainFrame == null) || (mailService == null)) {
      showError(LNG.get("MAIL_NO_SERVER_ERROR"));
      return false;
    }

    final String sndName = senderName;
    final Object uId = userId;
    final String cnt = content;
    final DesktopTask task = new DesktopTask() {
      @Override
      public void performTask() throws Exception {
        if (!mailService.mailTo(sndName, uId, cnt)) {
          final String err = LNG.get("MAIL_FAILED_MESSAGE");
          throw new Exception(err);
        }
      }
    };
    final String title = LNG.get("MAIL_SEND_TITLE");
    final String msg = LNG.get("MAIL_SEND_MESSAGE");
    task.start(mainFrame.getDesktopFrame(), title, msg);

    /* Informa se ocorreu uma exceo */
    final Exception exception = task.getException();
    if (exception != null) {
      if (showMsg) {
        showError(exception.getMessage());
      }
      return false;
    }
    return true;
  }

  /**
   * Mtodo para notifificao ao suporte.
   * 
   * @param content contedo da mensagem.
   * @return flag booleano de sucesso da operao.
   */
  public static boolean mailSupport(final String content) {
    final MailServiceInterface mailService = ClientRemoteLocator.mailService;
    final DesktopFrame mainFrame = DesktopFrame.getInstance();
    if ((mainFrame == null) || (mailService == null)) {
      showError(LNG.get("MAIL_NO_SERVER_ERROR"));
      return false;
    }
    final String cnt = content;
    final DesktopTask task = new DesktopTask() {
      @Override
      public void performTask() throws Exception {
        if (!mailService.mailSupport(cnt)) {
          final String err = LNG.get("MAIL_SUPPORT_FAILED_MESSAGE");
          throw new Exception(err);
        }
      }
    };

    final String title = LNG.get("MAIL_SEND_TITLE");
    final String msg = LNG.get("MAIL_SEND_MESSAGE");
    task.start(mainFrame.getDesktopFrame(), title, msg);

    /* Informa se ocorreu uma exceo */
    final Exception exception = task.getException();
    if (exception != null) {
      showError(exception.getMessage());
      return false;
    }
    return true;
  }
}
