package csbase.client.util.csvpanel;

import javax.swing.event.TableModelEvent;

import csbase.client.util.event.IEvent;

/**
 * Notificao de mudana na tabela de visualizao de arquivos CSV.
 * 
 * @author Tecgraf
 */
public class CSVTableModelNotification implements IEvent {

  /** O evento da tabela CSV que originou essa notificao. */
  private final TableModelEvent tableEvent;

  /**
   * Retorna o evento que originou essa notificao.
   * 
   * @return o evento.
   */
  public TableModelEvent getTableModelEvent() {
    return tableEvent;
  }

  /**
   * Construtor.
   * 
   * @param event o evento que originou essa notificao.
   */
  protected CSVTableModelNotification(TableModelEvent event) {
    this.tableEvent = event;
  }
}
