/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.algorithms.commands.view;

import csbase.client.algorithms.AlgorithmConfiguratorFactory;
import csbase.client.algorithms.commands.cache.CommandsCache;
import csbase.client.algorithms.commands.cache.events.AbstractCommandUpdatedEventListener;
import csbase.client.algorithms.commands.cache.events.CommandUpdatedEvent;
import csbase.client.algorithms.commands.view.AbstractAlgorithmCommandView;
import csbase.client.algorithms.commands.view.AlgorithmCommandViewFactory;
import csbase.client.algorithms.commands.view.CommandViewType;
import csbase.client.algorithms.commands.view.TabType;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.flowapplication.Workspace;
import csbase.client.applications.flowapplication.configurator.FlowAlgorithmConfiguratorView;
import csbase.client.applications.flowapplication.filters.AddNodePopupActionFilter;
import csbase.client.applications.flowapplication.filters.PopupFilter;
import csbase.client.applications.flowapplication.filters.WorkspaceFilter;
import csbase.client.applications.flowapplication.graph.Graph;
import csbase.client.applications.flowapplication.graph.GraphNode;
import csbase.client.applications.flowapplication.graph.GraphNodeImageDecoration;
import csbase.client.applications.flowapplication.graph.actions.Action;
import csbase.client.applications.flowapplication.graph.actions.GraphElementAction;
import csbase.client.applications.flowapplication.messages.PickNodeMessage;
import csbase.client.desktop.DesktopComponentFrame;
import csbase.client.kernel.ClientException;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.CommandFinalizationInfo;
import csbase.logic.CommandInfo;
import csbase.logic.CommandStatus;
import csbase.logic.ExtendedCommandFinalizationInfo;
import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.logic.algorithms.flows.configurator.FlowAlgorithmConfigurator;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GBC;
import tecgraf.vix.TypeVO;

final class FlowAlgorithmCommandView
extends AbstractAlgorithmCommandView {
    private FlowAlgorithmConfiguratorView configuratorView;
    private TabType preferredTab;

    public FlowAlgorithmCommandView(Object index, DesktopComponentFrame owner, CommandInfo command, AlgorithmConfigurator configurator) throws ClientException {
        super(index, owner, command, configurator, CommandViewType.FLOW, null);
    }

    @Override
    protected void initialize(AlgorithmConfigurator configurator) throws ClientException {
        AlgorithmConfiguratorFactory configuratorFactory = AlgorithmConfiguratorFactory.getInstance();
        this.configuratorView = (FlowAlgorithmConfiguratorView)configuratorFactory.createReportView(this.owner, configurator);
    }

    @Override
    public void show(TabType tab) {
        this.preferredTab = tab;
        super.show(tab);
    }

    @Override
    protected AbstractAlgorithmCommandView.ConfigurationReportTab createConfigurationReportTab(AlgorithmConfigurator configurator) throws ClientException {
        return new FlowConfiguratorReportTab(configurator);
    }

    private final class FlowConfiguratorReportTab
    extends AbstractAlgorithmCommandView.ConfigurationReportTab {
        private AbstractCommandUpdatedEventListener commandListener;

        FlowConfiguratorReportTab(AlgorithmConfigurator configurator) throws ClientException {
            super(FlowAlgorithmCommandView.this);
            this.addCommandListener();
            this.createFilters(FlowAlgorithmCommandView.this.configuratorView.getWorkspace());
            this.setLayout(new GridLayout());
            this.add((Component)FlowAlgorithmCommandView.this.configuratorView.getMainComponent(), new GBC(0, 0).both());
            this.addCommandStatusDecoration(FlowAlgorithmCommandView.this.getCommand(), FlowAlgorithmCommandView.this.configuratorView.getGraph());
        }

        private void addCommandListener() {
            CommandInfo command = FlowAlgorithmCommandView.this.getCommand();
            if (command != null && command.getStatus() != CommandStatus.FINISHED) {
                this.commandListener = this.createCommandListener(command);
                CommandsCache.getInstance().addEventListener(this.commandListener);
            }
        }

        private AbstractCommandUpdatedEventListener createCommandListener(CommandInfo command) {
            return new AbstractCommandUpdatedEventListener(command.getProjectId(), command.getId()){

                @Override
                public void eventFired(CommandUpdatedEvent.Type type, CommandInfo cmd) {
                    try {
                        FlowConfiguratorReportTab.this.addCommandStatusDecoration(cmd, FlowAlgorithmCommandView.this.configuratorView.getGraph());
                        if (cmd.getStatus() == CommandStatus.FINISHED && FlowConfiguratorReportTab.this.commandListener != null) {
                            CommandsCache.getInstance().removeEventListener(FlowConfiguratorReportTab.this.commandListener);
                        }
                    }
                    catch (ClientException e) {
                        StandardErrorDialogs.showErrorDialog((Window)FlowAlgorithmCommandView.this, e);
                    }
                }
            };
        }

        private void addCommandStatusDecoration(CommandInfo command, Graph graph) throws ClientException {
            if (command != null) {
                if (command.getStatus() == CommandStatus.FINISHED) {
                    FlowAlgorithmConfigurator configurator = (FlowAlgorithmConfigurator)FlowAlgorithmCommandView.this.getConfigurator();
                    CommandFinalizationInfo info = command.getFinalizationInfo();
                    if (info != null) {
                        if (configurator.canBeRunAsSimpleCommand()) {
                            GraphNode node = graph.getNodeCollection().iterator().next();
                            this.decorateNode(node, info, false, false);
                        } else if (info.getInfoType() == CommandFinalizationInfo.FinalizationInfoType.EXTENDED) {
                            ExtendedCommandFinalizationInfo finalizationInfo = (ExtendedCommandFinalizationInfo)info;
                            for (GraphNode node : graph.getNodeCollection()) {
                                CommandFinalizationInfo nodeFinalizationInfo = finalizationInfo.getFinalizationInfoForNode(node.getId());
                                Integer guiltyNodeId = finalizationInfo.getGuiltyNodeId();
                                boolean commandWasInterrupted = false;
                                boolean isGuilty = false;
                                if (guiltyNodeId != null) {
                                    commandWasInterrupted = true;
                                    if (guiltyNodeId.intValue() == node.getId()) {
                                        isGuilty = true;
                                    }
                                }
                                this.decorateNode(node, nodeFinalizationInfo, commandWasInterrupted, isGuilty);
                            }
                        }
                    }
                } else {
                    GraphNodeImageDecoration.DecorationType decoration;
                    switch (command.getStatus()) {
                        case SYSTEM_FAILURE: {
                            decoration = GraphNodeImageDecoration.DecorationType.SYSTEM_FAILURE;
                            break;
                        }
                        case SCHEDULED: {
                            decoration = GraphNodeImageDecoration.DecorationType.SCHEDULED;
                            break;
                        }
                        case INIT: 
                        case UPLOADING: 
                        case EXECUTING: 
                        case DOWNLOADING: {
                            decoration = GraphNodeImageDecoration.DecorationType.EXECUTION;
                            break;
                        }
                        default: {
                            decoration = GraphNodeImageDecoration.DecorationType.BLANK;
                        }
                    }
                    for (GraphNode graphNode : graph.getNodeCollection()) {
                        if (graphNode.isBypassed()) continue;
                        graphNode.addImageDecoration(decoration);
                    }
                }
            } else {
                throw new ClientException("N\u00e3o foi poss\u00edvel encontrar comando!");
            }
        }

        private void decorateNode(GraphNode node, CommandFinalizationInfo finalizationInfo, boolean commandWasInterrupted, boolean isGuilty) {
            GraphNodeImageDecoration.DecorationType decoration = GraphNodeImageDecoration.DecorationType.BLANK;
            if (!node.isBypassed()) {
                if (commandWasInterrupted && isGuilty) {
                    decoration = GraphNodeImageDecoration.DecorationType.FATAL_ERROR;
                } else {
                    switch (finalizationInfo.getFinalizationType()) {
                        case EXECUTION_ERROR: {
                            if (commandWasInterrupted) {
                                decoration = GraphNodeImageDecoration.DecorationType.NON_FATAL_ERROR;
                                break;
                            }
                            decoration = GraphNodeImageDecoration.DecorationType.EXECUTION_ERROR;
                            break;
                        }
                        case NO_EXIT_CODE: {
                            if (commandWasInterrupted) {
                                decoration = GraphNodeImageDecoration.DecorationType.INTERRUPTED;
                                break;
                            }
                            decoration = GraphNodeImageDecoration.DecorationType.EXECUTION_UNKNOWN;
                            break;
                        }
                        case SUCCESS: {
                            if (finalizationInfo.hasWarnings()) {
                                decoration = GraphNodeImageDecoration.DecorationType.EXECUTION_WARNING;
                                break;
                            }
                            decoration = GraphNodeImageDecoration.DecorationType.EXECUTION_SUCCESS;
                            break;
                        }
                        default: {
                            decoration = GraphNodeImageDecoration.DecorationType.BLANK;
                        }
                    }
                }
            }
            node.addImageDecoration(decoration);
        }

        @Override
        public String getTitle() {
            return LNG.get((String)"FlowAlgorithmCommandView.tab.params.title");
        }

        private void createFilters(Workspace workspace) {
            new AddNodePopupActionFilter(workspace){

                @Override
                protected Action createAction(GraphNode graphNode, Point2D point) {
                    return new ShowAlgorithmCommandViewPopupAction(graphNode);
                }
            }.attach();
            new PopupFilter(workspace).attach();
            new ShowAlgorithmCommandViewDoubleClickAction(workspace).attach();
        }

        private final class ShowAlgorithmCommandViewPopupAction
        extends GraphElementAction {
            public ShowAlgorithmCommandViewPopupAction(GraphNode node) {
                super(node, "FlowAlgorithmCommandView.tab.params.action.show.node.params", ApplicationImages.ICON_INFORMATION_16);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphNode node = (GraphNode)this.getElement();
                if (node != null) {
                    try {
                        AlgorithmCommandViewFactory.showView(FlowAlgorithmCommandView.this, FlowAlgorithmCommandView.this.getCommand(), node, FlowAlgorithmCommandView.this.preferredTab);
                    }
                    catch (Exception ex) {
                        StandardErrorDialogs.showErrorDialog((Window)FlowAlgorithmCommandView.this, ex);
                    }
                }
            }
        }

        private class ShowAlgorithmCommandViewDoubleClickAction
        extends WorkspaceFilter {
            public ShowAlgorithmCommandViewDoubleClickAction(Workspace workspace) {
                super(workspace);
            }

            public void callbackButton(Point2D pt, MouseEvent ev) {
                if (ev.getButton() == 1 && ev.getID() == 500 && ev.getClickCount() == 2) {
                    PickNodeMessage pickNodeMessage = new PickNodeMessage(pt);
                    pickNodeMessage.sendVO((TypeVO)this);
                    GraphNode node = pickNodeMessage.getNode();
                    if (node != null) {
                        try {
                            AlgorithmCommandViewFactory.showView(FlowAlgorithmCommandView.this, FlowAlgorithmCommandView.this.getCommand(), node, FlowAlgorithmCommandView.this.preferredTab);
                        }
                        catch (Exception ex) {
                            StandardErrorDialogs.showErrorDialog((Window)FlowAlgorithmCommandView.this, ex);
                        }
                    }
                }
                super.callbackButton(pt, ev);
            }
        }
    }
}

