/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.report.core;

import csbase.client.applications.algorithmsmanager.report.core.ISubjectFactory;
import csbase.client.applications.algorithmsmanager.report.core.ITest;
import csbase.client.applications.algorithmsmanager.report.core.ITestResult;
import java.awt.Window;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import tecgraf.javautils.gui.Task;

public class TestRunner {
    private final ISubjectFactory subjectFactory;
    private final Window parentWindow;
    private String taskTitle;
    private String taskMessage;

    public TestRunner(ISubjectFactory subjectFactory, Window parentWindow, String taskTitle, String taskMessage) {
        this.taskTitle = taskTitle;
        this.taskMessage = taskMessage;
        this.parentWindow = parentWindow;
        this.subjectFactory = subjectFactory;
    }

    public Map<ITest<?>, ITestResult<?>> run(final List<ITest<?>> runQueue) {
        Task task = new Task<Map<ITest<?>, ITestResult<?>>>(){

            protected void performTask() throws Exception {
                HashMap results = new HashMap();
                int i = 0;
                int n = runQueue.size();
                for (ITest test : runQueue) {
                    this.setProgressStatus(i * 100 / n);
                    ITestResult result = this.run(test);
                    if (result != null) {
                        results.put(test, result);
                    }
                    if (++i != n) continue;
                    this.setProgressStatus(100);
                }
                this.setResult(results);
            }

            public <T> ITestResult<T> run(ITest<T> test) {
                Iterable<T> subject = TestRunner.this.subjectFactory.createSubject(test);
                if (subject == null) {
                    return null;
                }
                return test.run(subject);
            }
        };
        task.execute(this.parentWindow, this.taskTitle, this.taskMessage, true, false);
        return (Map)task.getResult();
    }
}

