/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.ias;

import csbase.client.desktop.DesktopComponentDialog;
import csbase.client.remote.srvproxies.PermissionProxy;
import csbase.client.util.ClientUtilities;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.Permission;
import csbase.logic.User;
import csbase.logic.UserInfo;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.selector.ContainerSelection;
import tecgraf.javautils.gui.table.DefaultObjectTableProvider;
import tecgraf.javautils.gui.table.ObjectTableProvider;

public class UserPermissionDefinitionDialog {
    private UserInfo userInfo;
    private DesktopComponentDialog ownerWindow;
    private DesktopComponentDialog mainDialog;
    private String dialogTitle;
    private ContainerSelection<Permission> permissionsSelection;

    private Vector<Permission> getUserPermissions() {
        Object[] permissionIds = (Object[])this.userInfo.getAttribute("permissionIds");
        if (permissionIds == null) {
            return new Vector<Permission>();
        }
        Vector<Permission> permissions = new Vector<Permission>(permissionIds.length);
        try {
            for (int i = 0; i < permissionIds.length; ++i) {
                permissions.add(i, Permission.getPermission((Object)permissionIds[i]));
            }
        }
        catch (Exception e) {
            StandardErrorDialogs.showErrorDialog((Window)this.mainDialog, this.dialogTitle, LNG.get((String)"IAS_USER_PERMISSIONS_RETRIEVAL_ERROR"));
        }
        return permissions;
    }

    public void showDialog() {
        this.dialogTitle = LNG.get((String)"IAS_USER_PERMISSIONS_TITLE");
        this.mainDialog = new DesktopComponentDialog((Window)this.ownerWindow, this.dialogTitle);
        Vector<Permission> permissions = PermissionProxy.getAllPermissions(this.mainDialog, this.dialogTitle, LNG.get((String)"IAS_WAITING_ALL_PERMISSIONS"));
        if (permissions == null) {
            StandardErrorDialogs.showErrorDialog((Window)this.mainDialog, this.dialogTitle, LNG.get((String)"IAS_USER_PERMISSIONS_RETRIEVAL_ERROR"));
            return;
        }
        Container cp = this.mainDialog.getContentPane();
        JPanel selectionPanel = this.createSelectionPanel(permissions, this.getUserPermissions());
        cp.add((Component)selectionPanel, "Center");
        JButton confirmButton = new JButton(LNG.get((String)"IAS_CONFIRM"));
        confirmButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserPermissionDefinitionDialog.this.updateUserPermissions();
                UserPermissionDefinitionDialog.this.mainDialog.close();
            }
        });
        JButton cancelButton = new JButton(LNG.get((String)"IAS_CANCEL"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserPermissionDefinitionDialog.this.mainDialog.close();
            }
        });
        ClientUtilities.adjustEqualSizes(confirmButton, cancelButton);
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.add(confirmButton);
        buttonsPanel.add(cancelButton);
        cp.add((Component)buttonsPanel, "South");
        this.mainDialog.pack();
        this.mainDialog.center(this.ownerWindow);
        this.mainDialog.setVisible(true);
    }

    private JPanel createSelectionPanel(Vector<Permission> selectablePermissions, Vector<Permission> selectedPermissions) {
        DefaultObjectTableProvider selectableFormat = new DefaultObjectTableProvider(){

            public String[] getColumnNames() {
                return new String[]{LNG.get((String)"IAS_AVAILABLE_PERMISSIONS")};
            }

            public Class<?>[] getColumnClasses() {
                return new Class[]{String.class};
            }

            public Object[] getCellValues(Object arg0) {
                String[] stringArray;
                Permission permission = (Permission)arg0;
                if (permission == null) {
                    stringArray = null;
                } else {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = permission.getName();
                }
                return stringArray;
            }
        };
        DefaultObjectTableProvider selectedFormat = new DefaultObjectTableProvider(){

            public Class<?>[] getColumnClasses() {
                return new Class[]{String.class};
            }

            public String[] getColumnNames() {
                return new String[]{LNG.get((String)"IAS_SELECTED_PERMISSIONS")};
            }

            public Object[] getCellValues(Object arg0) {
                String[] stringArray;
                Permission permission = (Permission)arg0;
                if (permission == null) {
                    stringArray = null;
                } else {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = permission.getName();
                }
                return stringArray;
            }
        };
        this.permissionsSelection = new ContainerSelection((ObjectTableProvider)selectableFormat, (ObjectTableProvider)selectedFormat, true, false);
        this.permissionsSelection.loadItems(selectablePermissions, selectedPermissions);
        this.permissionsSelection.adjustTableColumns();
        return this.permissionsSelection.getPanel();
    }

    void updateUserPermissions() {
        if (this.permissionsSelection == null) {
            this.userInfo.setAttribute("permissionIds", (Object)new Object[0]);
            return;
        }
        List permissions = this.permissionsSelection.getSelectedItems();
        Object[] permissionIds = new Object[permissions.size()];
        for (int i = 0; i < permissions.size(); ++i) {
            permissionIds[i] = ((Permission)permissions.get(i)).getId();
        }
        this.userInfo.setAttribute("permissionIds", (Object)permissionIds);
    }

    public void clearSelected() {
        if (this.permissionsSelection != null) {
            this.permissionsSelection.clearSelectedItems();
        }
        this.updateUserPermissions();
    }

    public UserPermissionDefinitionDialog(DesktopComponentDialog ownerWindow, UserInfo userInfo, User user, boolean isNew) {
        this.ownerWindow = ownerWindow;
        this.userInfo = userInfo;
        if (user == null && !isNew) {
            throw new IllegalArgumentException("user == null");
        }
        if (!isNew) {
            this.userInfo.setAttribute("permissionIds", user.getAttribute("permissionIds"));
        }
    }

    public UserPermissionDefinitionDialog(DesktopComponentDialog ownerDialog, UserInfo userInfo, boolean isNew) {
        this(ownerDialog, userInfo, null, isNew);
    }
}

