/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.project.action;

import csbase.client.desktop.RemoteTask;
import csbase.client.project.ProjectFileContainer;
import csbase.client.project.action.CommonProjectAction;
import csbase.client.util.ClientUtilities;
import csbase.logic.ClientProjectFile;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;

public class CommonFileRenameAction
extends CommonProjectAction {
    public CommonFileRenameAction(ProjectFileContainer container) {
        super(container);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.startRenamingAction();
        this.clearClipboard();
    }

    @Override
    public String getName() {
        return LNG.get((String)"PRJ_RENAME");
    }

    public void rename(final ClientProjectFile file, String name) {
        int answer;
        if (file.getParent() == null) {
            return;
        }
        Window owner = this.getWindow();
        String ownerTitle = this.getTitle();
        final String nameTrimmed = name.trim();
        if (!ClientUtilities.isValidFileName(nameTrimmed)) {
            this.showError(owner, ownerTitle, LNG.get((String)"PRJ_PROJECT_FILE_NAME_CHARACTERES_ERROR"));
            return;
        }
        if (nameTrimmed.startsWith(".") && !file.getName().startsWith(".") && (answer = StandardDialogs.showYesNoDialog((Component)owner, (String)ownerTitle, (Object)LNG.get((String)"PRJ_PROJECT_FILE_UPLOAD_TO_HIDDEN_CONFIRMATION"))) != 0) {
            return;
        }
        String fileType = file.isDirectory() ? LNG.get((String)"PRJ_DIRECTORY") : LNG.get((String)"PRJ_FILE");
        RemoteTask<Void> task = new RemoteTask<Void>(){

            protected void performTask() throws Exception {
                file.rename(nameTrimmed);
            }
        };
        task.execute(owner, ownerTitle, MessageFormat.format(LNG.get((String)"PRJ_WAITING_RENAME_FILE"), fileType));
    }
}

