/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.project.dialogs;

import csbase.client.applications.ApplicationImages;
import csbase.client.desktop.RemoteTask;
import csbase.client.project.dialogs.ProjectCreationDialog;
import csbase.client.project.dialogs.ProjectDataExtensionPanel;
import csbase.client.project.dialogs.ProjectUpdateDialog;
import csbase.client.project.tasks.CheckAreaReservedTask;
import csbase.client.util.ClientUtilities;
import csbase.client.util.NumericTextField;
import csbase.client.util.user.UserDialog;
import csbase.logic.CommonClientProject;
import csbase.logic.User;
import csbase.logic.UserOutline;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.StandardDialogs;

public abstract class ProjectBuildingDialog
extends JDialog {
    protected final JCheckBox lockingBox = new JCheckBox(LNG.get((String)"ProjectBuildingDialog.locking.checkbox"));
    protected final NumericTextField sizeField = new NumericTextField(20);
    protected final JTextField projectOwnerField = new JTextField(User.getLoggedUser().getLogin());
    protected final JTextField nameField = new JTextField();
    final JTextArea descrField = new JTextArea();
    final JButton searchButton = new JButton();
    CommonClientProject project;
    final boolean allocation;
    final JButton okButton = new JButton();
    ProjectDataExtensionPanel extraPanel;

    ProjectBuildingDialog(Window owner) {
        this(owner, (CommonClientProject)null, (ProjectDataExtensionPanel)null);
    }

    ProjectBuildingDialog(Window owner, ProjectDataExtensionPanel extraPanel) {
        this(owner, null, extraPanel);
    }

    ProjectBuildingDialog(Window owner, CommonClientProject project) {
        this(owner, project, null);
    }

    ProjectBuildingDialog(Window owner, CommonClientProject project, ProjectDataExtensionPanel extraPanel) {
        super(owner);
        this.allocation = this.checkAreaReserved();
        this.project = project;
        this.extraPanel = extraPanel;
        this.clearDialog();
        this.buildDialog();
        this.addActions();
    }

    public static CommonClientProject createProject(Window owner, ProjectDataExtensionPanel extraPanel) {
        ProjectCreationDialog pcd = new ProjectCreationDialog(owner, extraPanel);
        pcd.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        pcd.pack();
        pcd.setLocationRelativeTo(owner);
        pcd.setVisible(true);
        return pcd.project;
    }

    public static CommonClientProject updateProject(Window owner, CommonClientProject project, ProjectDataExtensionPanel extraPanel) {
        ProjectUpdateDialog pud = new ProjectUpdateDialog(owner, project, extraPanel);
        pud.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        pud.pack();
        pud.setLocationRelativeTo(owner);
        pud.setVisible(true);
        return project;
    }

    private void buildDialog() {
        this.nameField.setColumns(22);
        this.descrField.setColumns(22);
        this.descrField.setRows(3);
        this.projectOwnerField.setEditable(false);
        this.projectOwnerField.setColumns(10);
        this.sizeField.setColumns(10);
        JScrollPane descrPane = new JScrollPane(this.descrField);
        descrPane.setVerticalScrollBarPolicy(22);
        descrPane.setHorizontalScrollBarPolicy(30);
        this.setLayout(new GridBagLayout());
        Insets regularEdgeInsets = new Insets(5, 15, 5, 15);
        Insets separatingEdgeInsets = new Insets(15, 15, 5, 15);
        this.add((Component)new JLabel(LNG.get((String)"ProjectCreationDialog.project.name.label")), new GBC(0, 0).west().insets(separatingEdgeInsets));
        this.add((Component)this.nameField, new GBC(1, 0).horizontal().insets(separatingEdgeInsets));
        this.add((Component)new JLabel(LNG.get((String)"ProjectBuildingDialog.project.descr.label")), new GBC(0, 1).height(2).northwest().insets(regularEdgeInsets));
        this.add((Component)descrPane, new GBC(1, 1).height(2).both().insets(regularEdgeInsets));
        int i = 3;
        User user = User.getLoggedUser();
        if (user.isAdmin()) {
            this.searchButton.setAction(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String title = LNG.get((String)"ProjectBuildingDialog.owner.selection.title");
                    try {
                        Set<Object> ids = UserDialog.showUserSelectionDialog(ProjectBuildingDialog.this, ProjectBuildingDialog.this.getUsers(), false, title);
                        if (ids != null) {
                            Object userId = ids.toArray()[0];
                            ProjectBuildingDialog.this.projectOwnerField.setText((String)userId);
                        }
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                        StandardDialogs.showErrorDialog((Component)ProjectBuildingDialog.this, (String)LNG.get((String)"ProjectBuildingDialog.obtaining.user.error.title"), (String)LNG.get((String)"ProjectBuildingDialog.obtaining.user.error.text"));
                        return;
                    }
                }
            });
            this.searchButton.setIcon(ApplicationImages.ICON_FIND_USER_16);
            this.searchButton.setMargin(new Insets(0, 0, 0, 0));
            this.searchButton.setToolTipText(LNG.get((String)"ProjectBuildingDialog.search.owner.tooltip"));
            JPanel ownerPanel = new JPanel(new GridBagLayout());
            ownerPanel.add((Component)this.projectOwnerField, new GBC(0, 0).insets(0, 0, 0, 5));
            ownerPanel.add((Component)this.searchButton, new GBC(1, 0).insets(0, 5, 0, 0));
            this.add((Component)new JLabel(LNG.get((String)"ProjectBuildingDialog.user.login.label")), new GBC(0, i).west().insets(separatingEdgeInsets));
            this.add((Component)ownerPanel, new GBC(1, i).west().insets(separatingEdgeInsets));
            ++i;
        }
        if (this.allocation) {
            this.lockingBox.setSelected(false);
            final JLabel sizeLabel = new JLabel(LNG.get((String)"ProjectBuildingDialog.locking.label"));
            sizeLabel.setEnabled(false);
            this.sizeField.setEnabled(false);
            this.lockingBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    boolean condition = e.getStateChange() == 1;
                    sizeLabel.setEnabled(condition);
                    ProjectBuildingDialog.this.sizeField.setEnabled(condition);
                }
            });
            JPanel lockPanel = new JPanel(new GridBagLayout());
            lockPanel.add((Component)this.sizeField, new GBC(0, 0).insets(0, 0, 0, 5));
            lockPanel.add((Component)sizeLabel, new GBC(1, 0).insets(0, 5, 0, 0));
            this.add((Component)this.lockingBox, new GBC(0, i).west().insets(5, 12, 5, 0));
            this.add((Component)lockPanel, new GBC(1, i).west().insets(regularEdgeInsets));
            ++i;
        }
        if (this.extraPanel != null) {
            this.add((Component)this.extraPanel, new GBC(0, i).both().width(2).insets(5, 12, 5, 0));
            ++i;
        }
        JPanel buttonPanel = this.makeButtonPanel();
        this.add((Component)buttonPanel, new GBC(0, i).width(2).horizontal().insets(15));
    }

    private void clearDialog() {
        this.nameField.setText("");
        this.descrField.setText("");
        Document document = this.nameField.getDocument();
        document.addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.setConfirmButtonState();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.setConfirmButtonState();
            }

            private void setConfirmButtonState() {
                String name = ProjectBuildingDialog.this.nameField.getText().trim();
                if (name.isEmpty()) {
                    ProjectBuildingDialog.this.okButton.setEnabled(false);
                } else {
                    ProjectBuildingDialog.this.okButton.setEnabled(true);
                }
            }
        });
    }

    private JPanel makeButtonPanel() {
        JPanel panel = new JPanel(new FlowLayout(1, 11, 0));
        this.initCreateButton();
        panel.add(this.okButton);
        JButton cancelButton = new JButton(LNG.get((String)"ProjectCreationDialog.cancel.button"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectBuildingDialog.this.dispose();
            }
        });
        panel.add(cancelButton);
        ClientUtilities.adjustEqualSizes(this.okButton, cancelButton);
        return panel;
    }

    private void initCreateButton() {
        this.setOkButton(this.okButton);
        this.okButton.setEnabled(false);
    }

    protected void addActions() {
        AbstractAction cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectBuildingDialog.this.dispose();
            }
        };
        KeyStroke cancelKeyStroke = KeyStroke.getKeyStroke(27, 0);
        JRootPane component = this.getRootPane();
        this.addActionToComponent(cancelAction, component, cancelKeyStroke, 1);
    }

    protected void addActionToComponent(AbstractAction action, JComponent component, KeyStroke keyStroke, int focusSituation) {
        InputMap inputMap = component.getInputMap(focusSituation);
        ActionMap actionMap = component.getActionMap();
        String actionMapKey = keyStroke.toString();
        inputMap.put(keyStroke, actionMapKey);
        actionMap.put(actionMapKey, action);
    }

    private List<UserOutline> getUsers() throws Exception {
        RemoteTask<List<UserOutline>> rt = new RemoteTask<List<UserOutline>>(){

            protected void performTask() throws Exception {
                List allUsers = User.getAllOutlines();
                this.setResult(allUsers);
            }
        };
        Window owner = this.getOwner();
        rt.execute(owner, LNG.get((String)"ProjectCreationDialog.retrieving.users.title"), LNG.get((String)"ProjectCreationDialog.retrieving.users.msg"));
        if (rt.wasCancelled()) {
            StandardDialogs.showErrorDialog((Component)owner, (String)LNG.get((String)"ProjectCreationDialog.users.retrieval.error.title"), (String)LNG.get((String)"ProjectCreationDialog.users.retrieval.error.msg"));
            return null;
        }
        if (!rt.getStatus()) {
            Exception exception = rt.getError();
            throw exception;
        }
        List users = (List)rt.getResult();
        if (users == null) {
            StandardDialogs.showErrorDialog((Component)owner, (String)LNG.get((String)"ProjectCreationDialog.no.users.title"), (String)LNG.get((String)"ProjectCreationDialog.no.users.msg"));
        }
        return users;
    }

    private boolean checkAreaReserved() {
        Window window = this.getOwner();
        CheckAreaReservedTask task = new CheckAreaReservedTask();
        task.execute(window, LNG.get((String)"ProjectCreationDialog.area.reserved.title"), LNG.get((String)"ProjectCreationDialog.area.reserved.msg"));
        if (task.wasCancelled()) {
            String title = LNG.get((String)"ProjectCreationDialog.area.reserved.cancelled.title");
            String msg = LNG.get((String)"ProjectCreationDialog.area.reserved.cancelled.msg");
            StandardDialogs.showErrorDialog((Component)window, (String)title, (String)msg);
            return false;
        }
        if (!task.getStatus()) {
            Exception exception = task.getError();
            String title = LNG.get((String)"ProjectCreationDialog.area.reserved.exception.title");
            String msg = LNG.get((String)"ProjectCreationDialog.area.reserved.exception.msg") + "\n" + exception.getMessage();
            StandardDialogs.showErrorDialog((Component)window, (String)title, (String)msg);
            return false;
        }
        return (Boolean)task.getResult();
    }

    abstract void setOkButton(JButton var1);
}

