/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.remote.srvproxies;

import csbase.client.Client;
import csbase.client.ClientServerManager;
import csbase.client.desktop.DesktopComponentFrame;
import csbase.client.desktop.DesktopFrame;
import csbase.client.desktop.RemoteTask;
import csbase.client.remote.AlgorithmManagementListener;
import csbase.client.util.StandardErrorDialogs;
import csbase.exception.CSBaseRuntimeException;
import csbase.exception.PermissionException;
import csbase.exception.algorithms.CategoriesFileNotSavedException;
import csbase.logic.AlgoEvent;
import csbase.logic.AlgorithmAdminPermission;
import csbase.logic.AlgorithmExecutionPermission;
import csbase.logic.CategoryAlgorithmsExecutionPermission;
import csbase.logic.FileInfo;
import csbase.logic.IPathFactory;
import csbase.logic.MonitoredServerListener;
import csbase.logic.ServerURI;
import csbase.logic.User;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmOutline;
import csbase.logic.algorithms.AlgorithmProperty;
import csbase.logic.algorithms.AlgorithmVersionId;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.logic.algorithms.Category;
import csbase.logic.algorithms.CategorySet;
import csbase.logic.algorithms.HistoryRecord;
import csbase.remote.AlgorithmServiceInterface;
import csbase.remote.ClientRemoteLocator;
import java.awt.Window;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.SwingThreadDispatcher;

public class AlgorithmManagementProxy {
    private static String taskTitle = LNG.get((String)"algomanager.title");
    private static CategorySet categorySet;
    private static SortedSet<AlgorithmInfo> allAlgorithmInfo;
    private static HashMap<AlgorithmInfo, SortedSet<Category>> algorithmToCategoryMap;
    private static List<AlgorithmManagementListener> managementList;
    private static boolean hasAllAlgorithms;
    private static boolean hasAllCategories;

    private static void addServerMonitorListener() {
        ClientServerManager.getInstance().addCommonListener(new MonitoredServerListener(){

            public void notifyConnectionLost(ServerURI serverURI) {
            }

            public void notifyConnectionReestablished(ServerURI serverURI) {
                AlgorithmManagementProxy.prepareCacheReload();
                AlgorithmManagementProxy.notifyAlgorithmsReloaded();
            }

            public void notifyLoggedIn(ServerURI serverURI) {
            }

            public void notifyLoggedOut(ServerURI serverURI) {
            }
        });
    }

    private static String getServerName() {
        String systemName = Client.getInstance().getSystemName();
        String serverName = null;
        RemoteTask<String> task = new RemoteTask<String>(){

            public void performTask() throws Exception {
                this.setResult(ClientRemoteLocator.server.getSystemName());
            }
        };
        task.setProgressDialogDelay(10);
        task.execute(DesktopFrame.getInstance().getDesktopFrame(), "", systemName + "...");
        if (!task.getStatus()) {
            serverName = "ERROR";
        }
        if ((serverName = (String)task.getResult()) == null) {
            serverName = "[" + systemName + "]";
        }
        return serverName;
    }

    public static void copyFiles(final AlgorithmVersionInfo sourceVersion, final List<FileInfo> files, final IPathFactory sourcePathFactory, final AlgorithmVersionInfo targetVersion, final FileInfo targetDir, final IPathFactory targetPathFactory, final boolean setExecutables, Window owner) {
        RemoteTask<Void> task = new RemoteTask<Void>(){

            public void performTask() throws Exception {
                AlgorithmServiceInterface algoService = ClientRemoteLocator.algorithmService;
                algoService.copyFiles(sourceVersion, files, sourcePathFactory, targetVersion, targetDir, targetPathFactory, setExecutables);
            }
        };
        task.execute(owner, taskTitle, LNG.get((String)"algomanager.msg.wait"));
    }

    public static AlgorithmInfo createAlgorithm(final String name, final String id, final Hashtable<String, String> fieldValues, Window owner) {
        RemoteTask<AlgorithmInfo> task = new RemoteTask<AlgorithmInfo>(){

            public void performTask() throws Exception {
                this.setResult(ClientRemoteLocator.algorithmService.createAlgorithm(name, id, fieldValues));
            }
        };
        task.execute(owner, taskTitle, LNG.get((String)"algomanager.msg.wait"));
        return (AlgorithmInfo)task.getResult();
    }

    public static AlgorithmInfo createVersion(final Object algoId, final int major, final int minor, final int patch, final Hashtable<String, String> properties, Window owner) {
        RemoteTask<AlgorithmInfo> task = new RemoteTask<AlgorithmInfo>(){

            public void performTask() throws Exception {
                this.setResult(ClientRemoteLocator.algorithmService.createVersion(algoId, major, minor, patch, properties));
            }
        };
        task.execute(owner, taskTitle, LNG.get((String)"algomanager.msg.wait"));
        return (AlgorithmInfo)task.getResult();
    }

    public static Category createCategory(final String parentCategoryId, final String name, Window owner) {
        RemoteTask<Category> task = new RemoteTask<Category>(){

            protected void performTask() throws Exception {
                if (ClientRemoteLocator.algorithmService != null) {
                    Category category = ClientRemoteLocator.algorithmService.createCategory(parentCategoryId, name);
                    this.setResult(category);
                }
            }

            @Override
            protected void handleServerError(CSBaseRuntimeException error) {
                if (error instanceof CategoriesFileNotSavedException) {
                    StandardErrorDialogs.showErrorDialog((Window)DesktopFrame.getInstance().getView(), "Criando Categoria de Algoritmos", "Erro na persist\u00eancia do arquivo de categorias. Suas \u00faltimas altera\u00e7\u00f5es sobre categorias est\u00e3o salvas somente em mem\u00f3ria. ");
                } else {
                    super.handleServerError(error);
                }
            }
        };
        task.execute(owner, taskTitle, LNG.get((String)"algomanager.msg.wait"));
        return (Category)task.getResult();
    }

    public static boolean removeCategory(final String id, Window owner) {
        RemoteTask<Void> task = new RemoteTask<Void>(){

            protected void performTask() throws Exception {
                if (ClientRemoteLocator.algorithmService != null) {
                    ClientRemoteLocator.algorithmService.removeCategory(id);
                }
            }

            @Override
            protected void handleServerError(CSBaseRuntimeException error) {
                if (error instanceof CategoriesFileNotSavedException) {
                    StandardErrorDialogs.showErrorDialog((Window)DesktopFrame.getInstance().getView(), "Removendo Categoria de Algoritmos", "Erro na persist\u00eancia do arquivo de categorias. Suas \u00faltimas altera\u00e7\u00f5es sobre categorias est\u00e3o salvas somente em mem\u00f3ria. ");
                } else {
                    super.handleServerError(error);
                }
            }
        };
        return task.execute(owner, taskTitle, LNG.get((String)"algomanager.msg.wait"));
    }

    public static CategorySet bindAlgorithmsToCategories(final List<Object> algorithmIds, final List<String> categoryIds, Window owner, AlgorithmOperation algoOperation) {
        RemoteTask<CategorySet> task = new RemoteTask<CategorySet>(){

            protected void performTask() throws Exception {
                if (ClientRemoteLocator.algorithmService != null) {
                    CategorySet modifiedCategories = ClientRemoteLocator.algorithmService.bindAlgorithmsToCategories(algorithmIds, categoryIds);
                    this.setResult(modifiedCategories);
                }
            }

            @Override
            protected void handleServerError(CSBaseRuntimeException error) {
                if (error instanceof CategoriesFileNotSavedException) {
                    StandardErrorDialogs.showErrorDialog((Window)DesktopFrame.getInstance().getView(), "Associando algoritmos a categorias", "Erro na persist\u00eancia do arquivo de categorias. Suas \u00faltimas altera\u00e7\u00f5es sobre categorias est\u00e3o salvas somente em mem\u00f3ria. ");
                } else {
                    super.handleServerError(error);
                }
            }
        };
        task.execute(owner, taskTitle, LNG.get((String)"algomanager.msg.wait"));
        CategorySet categorySet = (CategorySet)task.getResult();
        if (!AlgorithmManagementProxy.isAdminLoggedUser()) {
            return AlgorithmManagementProxy.getRestrictedCategories(categorySet.getCategories(), algoOperation);
        }
        return categorySet;
    }

    public static CategorySet unbindAlgorithmsFromCategories(final List<Object> algorithmIds, final List<String> categoryIds, Window owner, AlgorithmOperation algoOperation) {
        RemoteTask<CategorySet> task = new RemoteTask<CategorySet>(){

            protected void performTask() throws Exception {
                if (ClientRemoteLocator.algorithmService != null) {
                    CategorySet modifiedCategories = ClientRemoteLocator.algorithmService.unbindAlgorithmsFromCategories(algorithmIds, categoryIds);
                    this.setResult(modifiedCategories);
                }
            }

            @Override
            protected void handleServerError(CSBaseRuntimeException error) {
                if (error instanceof CategoriesFileNotSavedException) {
                    StandardErrorDialogs.showErrorDialog((Window)DesktopFrame.getInstance().getView(), "Desassociando algoritmos de categorias", "Erro na persist\u00eancia do arquivo de categorias. Suas \u00faltimas altera\u00e7\u00f5es sobre categorias est\u00e3o salvas somente em mem\u00f3ria. ");
                } else {
                    super.handleServerError(error);
                }
            }
        };
        task.execute(owner, taskTitle, LNG.get((String)"algomanager.msg.wait"));
        CategorySet categorySet = (CategorySet)task.getResult();
        if (!AlgorithmManagementProxy.isAdminLoggedUser()) {
            return AlgorithmManagementProxy.getRestrictedCategories(categorySet.getCategories(), algoOperation);
        }
        return categorySet;
    }

    public static CategorySet setAlgorithmsToCategories(final List<Object> algorithmIds, final List<String> categoryIds, Window owner, AlgorithmOperation algoOperation) {
        RemoteTask<CategorySet> task = new RemoteTask<CategorySet>(){

            protected void performTask() throws Exception {
                if (ClientRemoteLocator.algorithmService != null) {
                    CategorySet modifiedCategories = ClientRemoteLocator.algorithmService.setAlgorithmsToCategories(algorithmIds, categoryIds);
                    this.setResult(modifiedCategories);
                }
            }

            @Override
            protected void handleServerError(CSBaseRuntimeException error) {
                if (error instanceof CategoriesFileNotSavedException) {
                    StandardErrorDialogs.showErrorDialog((Window)DesktopFrame.getInstance().getView(), "Atribuindo algoritmos a categorias", "Erro na persist\u00eancia do arquivo de categorias. Suas \u00faltimas altera\u00e7\u00f5es sobre categorias est\u00e3o salvas somente em mem\u00f3ria. ");
                } else {
                    super.handleServerError(error);
                }
            }
        };
        task.execute(owner, taskTitle, LNG.get((String)"algomanager.msg.wait"));
        CategorySet categorySet = (CategorySet)task.getResult();
        if (!AlgorithmManagementProxy.isAdminLoggedUser()) {
            return AlgorithmManagementProxy.getRestrictedCategories(categorySet.getCategories(), algoOperation);
        }
        return categorySet;
    }

    public static void duplicateVersion(final Object algoId, final Object versionId, final int major, final int minor, final int patch, Window owner) {
        RemoteTask<Void> task = new RemoteTask<Void>(){

            public void performTask() throws Exception {
                AlgorithmServiceInterface algoService = ClientRemoteLocator.algorithmService;
                algoService.duplicateVersion(algoId, versionId, major, minor, patch);
            }
        };
        task.execute(owner, taskTitle, LNG.get((String)"algomanager.msg.wait"));
    }

    public static CategorySet getAllCategories(Window owner, AlgorithmOperation algoOperation) {
        if (algoOperation == null) {
            throw new IllegalArgumentException(AlgorithmManagementProxy.getParameterNullMessage("algoOperation"));
        }
        CategorySet categorySet = null;
        if (!hasAllCategories) {
            categorySet = AlgorithmManagementProxy.loadCategoriesFromServer(owner);
            AlgorithmManagementProxy.updateCategoriesCache(categorySet);
        } else {
            categorySet = AlgorithmManagementProxy.categorySet;
        }
        if (!AlgorithmManagementProxy.isAdminLoggedUser()) {
            return AlgorithmManagementProxy.getRestrictedCategories(categorySet.getCategories(), algoOperation);
        }
        return categorySet;
    }

    public Category getCategory(final String categoryId, Window owner, AlgorithmOperation algoOperation) {
        if (algoOperation == null) {
            throw new IllegalArgumentException(AlgorithmManagementProxy.getParameterNullMessage("algoOperation"));
        }
        RemoteTask<Category> task = new RemoteTask<Category>(){

            public void performTask() throws Exception {
                this.setResult(ClientRemoteLocator.algorithmService.getCategory(categoryId));
            }
        };
        task.execute(owner, LNG.get((String)"algomanager.title.consulting_data"), LNG.get((String)"algomanager.msg.consulting_data"));
        Category category = (Category)task.getResult();
        if (!AlgorithmManagementProxy.isAdminLoggedUser()) {
            Category restrictedCategory = new Category(category);
            AlgorithmManagementProxy.updateRestrictedAlgorithms(restrictedCategory, algoOperation);
            AlgorithmManagementProxy.updateRestrictedCategories(restrictedCategory, restrictedCategory.getCategories().iterator(), algoOperation);
            return restrictedCategory;
        }
        return category;
    }

    public static AlgorithmOutline[] getAllAlgorithmOutlines(Window owner, AlgorithmOperation algoOperation) {
        if (algoOperation == null) {
            throw new IllegalArgumentException(AlgorithmManagementProxy.getParameterNullMessage("algoOperation"));
        }
        RemoteTask<AlgorithmOutline[]> task = new RemoteTask<AlgorithmOutline[]>(){

            public void performTask() throws Exception {
                AlgorithmOutline[] allAlgoOutlines = ClientRemoteLocator.algorithmService.getAllOutlines();
                this.setResult(allAlgoOutlines);
            }
        };
        task.execute(owner, LNG.get((String)"algomanager.title.consulting_data"), LNG.get((String)"algomanager.msg.consulting_data"));
        AlgorithmOutline[] algoOutlines = (AlgorithmOutline[])task.getResult();
        Vector outlinesList = new Vector();
        Collections.addAll(outlinesList, algoOutlines);
        AlgorithmManagementProxy.updateRestrictedAlgorithmOutlines(outlinesList.iterator(), owner, algoOperation);
        return outlinesList.toArray(new AlgorithmOutline[outlinesList.size()]);
    }

    public static Object[] getAllAlgorithmIds(Window owner, AlgorithmOperation algoOperation) {
        if (algoOperation == null) {
            throw new IllegalArgumentException(AlgorithmManagementProxy.getParameterNullMessage("algoOperation"));
        }
        RemoteTask<Object[]> task = new RemoteTask<Object[]>(){

            public void performTask() throws Exception {
                Object[] allAlgoIds = ClientRemoteLocator.algorithmService.getAllIds();
                this.setResult(allAlgoIds);
            }
        };
        task.execute(owner, LNG.get((String)"algomanager.title.consulting_data"), LNG.get((String)"algomanager.msg.consulting_data"));
        Object[] algoIds = (Object[])task.getResult();
        Vector idsList = new Vector();
        Collections.addAll(idsList, algoIds);
        AlgorithmManagementProxy.updateRestrictedAlgorithmIds(idsList.iterator(), owner, algoOperation);
        return idsList.toArray(new Object[idsList.size()]);
    }

    private static void updateRestrictedAlgorithmOutlines(Iterator<AlgorithmOutline> outlineIterator, Window owner, AlgorithmOperation algoOperation) {
        AlgorithmInfo[] restrictedAlgoInfos = AlgorithmManagementProxy.getAllAlgorithmInfos(owner, algoOperation);
        Vector<Object> restrictedAlgoIds = AlgorithmManagementProxy.getAlgorithmIdsList(restrictedAlgoInfos);
        while (outlineIterator.hasNext()) {
            AlgorithmOutline algoOutline = outlineIterator.next();
            if (restrictedAlgoIds.contains(algoOutline.getId())) continue;
            outlineIterator.remove();
        }
    }

    private static void updateRestrictedAlgorithmIds(Iterator<Object> idsIterator, Window owner, AlgorithmOperation algoOperation) {
        AlgorithmInfo[] restrictedAlgoInfos = AlgorithmManagementProxy.getAllAlgorithmInfos(owner, algoOperation);
        Vector<Object> restrictedAlgoIds = AlgorithmManagementProxy.getAlgorithmIdsList(restrictedAlgoInfos);
        while (idsIterator.hasNext()) {
            Object algoId = idsIterator.next();
            if (restrictedAlgoIds.contains(algoId)) continue;
            idsIterator.remove();
        }
    }

    private static Vector<Object> getAlgorithmIdsList(AlgorithmInfo[] algoInfos) {
        Vector<Object> algoIds = new Vector<Object>();
        for (AlgorithmInfo algoInfo : algoInfos) {
            algoIds.add(algoInfo.getId());
        }
        return algoIds;
    }

    public static String getConfiguratorURL(final Object algoId, final Object versionId, Window owner) {
        RemoteTask<String> task = new RemoteTask<String>(){

            public void performTask() throws Exception {
                this.setResult(ClientRemoteLocator.algorithmService.retrieveConfigUploadURL(algoId, versionId));
            }
        };
        task.execute(owner, taskTitle, LNG.get((String)"algomanager.msg.wait"));
        String result = (String)task.getResult();
        if (result == null) {
            AlgorithmManagementProxy.showError(LNG.get((String)"HTTP_URL_ERROR"), null);
        }
        return result;
    }

    public static String getExecutableURL(final Object algoId, final Object versionId, final String platform, Window owner) {
        RemoteTask<String> task = new RemoteTask<String>(){

            public void performTask() throws Exception {
                this.setResult(ClientRemoteLocator.algorithmService.retrieveExecUploadURL(algoId, versionId, platform));
            }
        };
        task.execute(owner, taskTitle, LNG.get((String)"algomanager.msg.wait"));
        String result = (String)task.getResult();
        if (result == null) {
            AlgorithmManagementProxy.showError(LNG.get((String)"HTTP_URL_ERROR"), null);
        }
        return result;
    }

    public static AlgorithmInfo getAlgorithmInfoByName(final String name, Window owner, final AlgorithmOperation algoOperation) {
        RemoteTask<AlgorithmInfo> task = new RemoteTask<AlgorithmInfo>(){

            public void performTask() throws Exception {
                AlgorithmInfo algoInfo = AlgorithmInfo.getAlgorithmInfo((String)name);
                this.setResult(algoInfo);
                if (!AlgorithmManagementProxy.isAlgorithmOwnerUser(algoInfo)) {
                    if (AlgorithmManagementProxy.isAdminOperation(algoOperation)) {
                        AlgorithmManagementProxy.checkAlgorithmAdminPermission(algoInfo);
                    } else if (AlgorithmManagementProxy.isExecuteOperation(algoOperation)) {
                        CategorySet allCategories = ClientRemoteLocator.algorithmService.getAllCategories();
                        AlgorithmManagementProxy.checkAlgorithmExecutePermission(algoInfo, allCategories);
                    }
                }
            }
        };
        task.execute(owner, LNG.get((String)"algorithm.title.getting"), LNG.get((String)"algorithm.msg.getting"));
        return (AlgorithmInfo)task.getResult();
    }

    public static AlgorithmInfo getAlgorithmInfoById(final Object algoId, Window owner, final AlgorithmOperation algoOperation) {
        RemoteTask<AlgorithmInfo> task = new RemoteTask<AlgorithmInfo>(){

            public void performTask() throws Exception {
                AlgorithmInfo algoInfo = AlgorithmInfo.getAlgorithmInfo((Object)algoId);
                this.setResult(algoInfo);
                if (!AlgorithmManagementProxy.isAlgorithmOwnerUser(algoInfo)) {
                    if (AlgorithmManagementProxy.isAdminOperation(algoOperation)) {
                        AlgorithmManagementProxy.checkAlgorithmAdminPermission(algoInfo);
                    } else if (AlgorithmManagementProxy.isExecuteOperation(algoOperation)) {
                        CategorySet allCategories = ClientRemoteLocator.algorithmService.getAllCategories();
                        AlgorithmManagementProxy.checkAlgorithmExecutePermission(algoInfo, allCategories);
                    }
                }
            }
        };
        task.execute(owner, LNG.get((String)"algorithm.title.getting"), LNG.get((String)"algorithm.msg.getting"));
        return (AlgorithmInfo)task.getResult();
    }

    public static AlgorithmInfo includePlatform(final Object algoId, final Object versionId, final String platform, Window owner) {
        RemoteTask<AlgorithmInfo> task = new RemoteTask<AlgorithmInfo>(){

            public void performTask() throws Exception {
                this.setResult(ClientRemoteLocator.algorithmService.includePlatform(algoId, versionId, platform));
            }
        };
        task.execute(owner, taskTitle, LNG.get((String)"algomanager.msg.wait"));
        return (AlgorithmInfo)task.getResult();
    }

    public static boolean reloadAlgorithms(Window owner) {
        RemoteTask<Boolean> task = new RemoteTask<Boolean>(){

            public void performTask() throws Exception {
                this.setResult(ClientRemoteLocator.algorithmService.reloadAlgorithms());
            }
        };
        if (task.execute(owner, LNG.get((String)"algorithm.title.reloading"), LNG.get((String)"algorithm.msg.reloading")) && ((Boolean)task.getResult()).booleanValue()) {
            AlgorithmManagementProxy.prepareCacheReload();
            return true;
        }
        return false;
    }

    private static void prepareCacheReload() {
        hasAllAlgorithms = false;
        hasAllCategories = false;
    }

    public static boolean removeAlgorithm(final Object algoId, Window owner) {
        RemoteTask<Boolean> task = new RemoteTask<Boolean>(){

            public void performTask() throws Exception {
                this.setResult(ClientRemoteLocator.algorithmService.removeAlgorithm(algoId));
            }
        };
        return task.execute(owner, taskTitle, LNG.get((String)"algomanager.msg.wait")) && (Boolean)task.getResult() != false;
    }

    public static boolean removeExecutableFiles(final AlgorithmVersionInfo version, final String platform, final FileInfo[] files, Window window) {
        RemoteTask<Void> task = new RemoteTask<Void>(){

            public void performTask() throws Exception {
                AlgorithmServiceInterface algoService = ClientRemoteLocator.algorithmService;
                algoService.removeExecutableFiles(version, platform, files);
            }
        };
        return task.execute(window, taskTitle, LNG.get((String)"algomanager.msg.wait"));
    }

    public static boolean removeConfigurationFiles(final AlgorithmVersionInfo version, final FileInfo[] files, Window window) {
        RemoteTask<Void> task = new RemoteTask<Void>(){

            public void performTask() throws Exception {
                AlgorithmServiceInterface algoService = ClientRemoteLocator.algorithmService;
                algoService.removeConfigurationFiles(version, files);
            }
        };
        return task.execute(window, taskTitle, LNG.get((String)"algomanager.msg.wait"));
    }

    public static boolean removeDocumentationFiles(final AlgorithmVersionInfo version, final FileInfo[] files, Window window) {
        RemoteTask<Void> task = new RemoteTask<Void>(){

            public void performTask() throws Exception {
                AlgorithmServiceInterface algoService = ClientRemoteLocator.algorithmService;
                algoService.removeDocumentationFiles(version, files);
            }
        };
        return task.execute(window, taskTitle, LNG.get((String)"algomanager.msg.wait"));
    }

    public static boolean removeReleaseNotesFiles(final AlgorithmVersionInfo version, final FileInfo[] files, Window window) {
        RemoteTask<Void> task = new RemoteTask<Void>(){

            public void performTask() throws Exception {
                AlgorithmServiceInterface algoService = ClientRemoteLocator.algorithmService;
                algoService.removeReleaseNotesFiles(version, files);
            }
        };
        return task.execute(window, taskTitle, LNG.get((String)"algomanager.msg.wait"));
    }

    public static AlgorithmInfo removePlatform(final Object algoId, final Object versionId, final String platform, Window owner) {
        RemoteTask<AlgorithmInfo> task = new RemoteTask<AlgorithmInfo>(){

            public void performTask() throws Exception {
                this.setResult(ClientRemoteLocator.algorithmService.removePlatform(algoId, versionId, platform));
            }
        };
        task.execute(owner, taskTitle, LNG.get((String)"algomanager.msg.wait"));
        return (AlgorithmInfo)task.getResult();
    }

    public static AlgorithmInfo removeVersion(final Object algoId, final Object versionId, Window owner) {
        RemoteTask<AlgorithmInfo> task = new RemoteTask<AlgorithmInfo>(){

            public void performTask() throws Exception {
                this.setResult(ClientRemoteLocator.algorithmService.removeVersion(algoId, versionId));
            }
        };
        task.execute(owner, taskTitle, LNG.get((String)"algomanager.msg.wait"));
        return (AlgorithmInfo)task.getResult();
    }

    public static AlgorithmInfo[] getAllAlgorithmInfos(Window owner, AlgorithmOperation algoOperation) {
        if (algoOperation == null) {
            throw new IllegalArgumentException(AlgorithmManagementProxy.getParameterNullMessage("algoOperation"));
        }
        AlgorithmInfo[] algoInfos = null;
        if (!hasAllAlgorithms) {
            algoInfos = AlgorithmManagementProxy.loadAlgorithmsFromServer(owner);
            AlgorithmManagementProxy.updateAlgorithmsCache(algoInfos);
        } else {
            algoInfos = allAlgorithmInfo.toArray(new AlgorithmInfo[allAlgorithmInfo.size()]);
        }
        AlgorithmInfo[] restrictedAlgorithms = algoInfos;
        if (!AlgorithmManagementProxy.isAdminLoggedUser()) {
            if (AlgorithmManagementProxy.isAdminOperation(algoOperation)) {
                restrictedAlgorithms = AlgorithmManagementProxy.getRestrictedAdminAlgorithms(algoInfos);
            } else if (AlgorithmManagementProxy.isExecuteOperation(algoOperation)) {
                CategorySet allCategories = AlgorithmManagementProxy.getAllCategories(owner, algoOperation);
                restrictedAlgorithms = AlgorithmManagementProxy.getRestrictedExecuteAlgorithms(algoInfos, allCategories);
            }
        }
        return restrictedAlgorithms;
    }

    private static AlgorithmInfo[] loadAlgorithmsFromServer(Window owner) {
        RemoteTask<AlgorithmInfo[]> task = new RemoteTask<AlgorithmInfo[]>(){

            public void performTask() throws Exception {
                this.setResult(ClientRemoteLocator.algorithmService.getAllInfo());
            }
        };
        task.execute(owner, LNG.get((String)"algomanager.title.consulting_data"), LNG.get((String)"algomanager.msg.consulting_data"));
        return (AlgorithmInfo[])task.getResult();
    }

    private static CategorySet loadCategoriesFromServer(Window owner) {
        RemoteTask<CategorySet> task = new RemoteTask<CategorySet>(){

            public void performTask() throws Exception {
                this.setResult(ClientRemoteLocator.algorithmService.getAllCategories());
            }
        };
        task.execute(owner, LNG.get((String)"algomanager.title.consulting_data"), LNG.get((String)"algomanager.msg.consulting_data"));
        return (CategorySet)task.getResult();
    }

    private static AlgorithmInfo[] getRestrictedExecuteAlgorithms(AlgorithmInfo[] algoInfos, CategorySet allCategories) {
        Vector<AlgorithmInfo> restrictedAlgorithms = new Vector<AlgorithmInfo>();
        boolean hasPermisssion = false;
        for (AlgorithmInfo algorithmInfo : algoInfos) {
            if (AlgorithmManagementProxy.isAlgorithmOwnerUser(algorithmInfo)) {
                hasPermisssion = true;
            } else {
                try {
                    AlgorithmManagementProxy.checkAlgorithmExecutePermission(algorithmInfo, allCategories);
                    hasPermisssion = true;
                }
                catch (PermissionException e) {
                    hasPermisssion = false;
                }
                catch (Exception e) {
                    hasPermisssion = false;
                }
            }
            if (!hasPermisssion) continue;
            restrictedAlgorithms.add(algorithmInfo);
        }
        return restrictedAlgorithms.toArray(new AlgorithmInfo[restrictedAlgorithms.size()]);
    }

    private static AlgorithmInfo[] getRestrictedAdminAlgorithms(AlgorithmInfo[] algoInfos) {
        Vector<AlgorithmInfo> restrictedAlgorithms = new Vector<AlgorithmInfo>();
        for (AlgorithmInfo algorithmInfo : algoInfos) {
            if (!AlgorithmManagementProxy.isAlgorithmOwnerUser(algorithmInfo) && !AlgorithmManagementProxy.hasAlgorithmAdminPermission(algorithmInfo)) continue;
            restrictedAlgorithms.add(algorithmInfo);
        }
        return restrictedAlgorithms.toArray(new AlgorithmInfo[restrictedAlgorithms.size()]);
    }

    public static String retrieveDownloadURL(final Object algoId, final String[] filePath, Window owner) {
        RemoteTask<String> task = new RemoteTask<String>(){

            public void performTask() throws Exception {
                AlgorithmServiceInterface algoService = ClientRemoteLocator.algorithmService;
                this.setResult(algoService.retrieveDownloadURL(algoId, filePath));
            }
        };
        task.execute(owner, taskTitle, LNG.get((String)"algomanager.msg.wait"));
        return (String)task.getResult();
    }

    public static String retrieveDocUploadURL(final Object algoId, final Object versionId, Window owner) {
        RemoteTask<String> task = new RemoteTask<String>(){

            public void performTask() throws Exception {
                AlgorithmServiceInterface algoService = ClientRemoteLocator.algorithmService;
                this.setResult(algoService.retrieveDocUploadURL(algoId, versionId));
            }
        };
        task.execute(owner, taskTitle, LNG.get((String)"algomanager.msg.wait"));
        return (String)task.getResult();
    }

    public static String retrieveReleaseNotesUploadURL(final Object algoId, final Object versionId, Window owner) {
        RemoteTask<String> task = new RemoteTask<String>(){

            public void performTask() throws Exception {
                AlgorithmServiceInterface algoService = ClientRemoteLocator.algorithmService;
                this.setResult(algoService.retrieveReleaseNotesUploadURL(algoId, versionId));
            }
        };
        task.execute(owner, taskTitle, LNG.get((String)"algomanager.msg.wait"));
        return (String)task.getResult();
    }

    public static List<HistoryRecord> retrieveHistory(final String[] path) {
        RemoteTask<List<HistoryRecord>> task = new RemoteTask<List<HistoryRecord>>(){

            public void performTask() throws Exception {
                AlgorithmServiceInterface algoService = ClientRemoteLocator.algorithmService;
                this.setResult(algoService.retrieveHistory(path));
            }
        };
        DesktopComponentFrame owner = DesktopFrame.getInstance().getDesktopFrame();
        task.execute(owner, taskTitle, LNG.get((String)"algomanager.msg.wait"));
        return (List)task.getResult();
    }

    private static void showError(String msg, Exception e) {
        DesktopFrame mainFrame = DesktopFrame.getInstance();
        if (mainFrame == null) {
            return;
        }
        DesktopComponentFrame jFrame = mainFrame.getDesktopFrame();
        if (jFrame == null) {
            return;
        }
        String title = LNG.get((String)"algomanager.title.error") + " - " + LNG.get((String)"algomanager.title");
        if (e != null) {
            StandardErrorDialogs.showErrorDialog(jFrame, title, msg, e);
        } else {
            StandardErrorDialogs.showErrorDialog((Window)jFrame, title, msg);
        }
    }

    public static AlgorithmInfo renameAlgorithm(final Object id, final String name, Window owner) {
        RemoteTask<AlgorithmInfo> task = new RemoteTask<AlgorithmInfo>(){

            public void performTask() throws Exception {
                this.setResult(ClientRemoteLocator.algorithmService.renameAlgorithm(id, name));
            }
        };
        task.execute(owner, taskTitle, LNG.get((String)"algomanager.msg.wait"));
        return (AlgorithmInfo)task.getResult();
    }

    public static AlgorithmInfo changeAlgorithmProperties(final String name, final Hashtable<String, String> newValues, Window owner) {
        RemoteTask<AlgorithmInfo> task = new RemoteTask<AlgorithmInfo>(){

            public void performTask() throws Exception {
                this.setResult(ClientRemoteLocator.algorithmService.changeAlgorithmProperties(name, newValues));
            }
        };
        task.execute(owner, taskTitle, LNG.get((String)"algomanager.msg.wait"));
        return (AlgorithmInfo)task.getResult();
    }

    public static AlgorithmInfo changeVersionProperties(final String name, final AlgorithmVersionId versionId, final Hashtable<String, String> newValues, Window owner) {
        RemoteTask<AlgorithmInfo> task = new RemoteTask<AlgorithmInfo>(){

            public void performTask() throws Exception {
                this.setResult(ClientRemoteLocator.algorithmService.changeVersionProperties(name, versionId, newValues));
            }
        };
        task.execute(owner, taskTitle, LNG.get((String)"algomanager.msg.wait"));
        return (AlgorithmInfo)task.getResult();
    }

    public static List<AlgorithmProperty> getAlgorithmVersionProperties(Window owner) {
        RemoteTask<List<AlgorithmProperty>> task = new RemoteTask<List<AlgorithmProperty>>(){

            public void performTask() throws Exception {
                AlgorithmServiceInterface algoService = ClientRemoteLocator.algorithmService;
                this.setResult(algoService.getVersionProperties());
            }
        };
        task.execute(owner, taskTitle, LNG.get((String)"algomanager.msg.wait"));
        return (List)task.getResult();
    }

    public static List<AlgorithmProperty> getAlgorithmProperties(Window owner) {
        RemoteTask<List<AlgorithmProperty>> task = new RemoteTask<List<AlgorithmProperty>>(){

            public void performTask() throws Exception {
                AlgorithmServiceInterface algoService = ClientRemoteLocator.algorithmService;
                this.setResult(algoService.getAlgorithmProperties());
            }
        };
        task.execute(owner, taskTitle, LNG.get((String)"algomanager.msg.wait"));
        return (List)task.getResult();
    }

    public static String getVersionURL(final Object algoId, Window owner) {
        RemoteTask<String> task = new RemoteTask<String>(){

            public void performTask() throws Exception {
                AlgorithmServiceInterface algoService = ClientRemoteLocator.algorithmService;
                if (algoService != null) {
                    this.setResult(algoService.retrieveVersionUploadURL(algoId));
                }
            }
        };
        if (!task.execute(owner, taskTitle, LNG.get((String)"algomanager.msg.wait"))) {
            return null;
        }
        Object result = task.getResult();
        if (result == null) {
            AlgorithmManagementProxy.showError(LNG.get((String)"HTTP_URL_ERROR"), null);
        }
        return (String)result;
    }

    private static CategorySet getRestrictedCategories(SortedSet<Category> categories, AlgorithmOperation algoOperation) {
        CategorySet restrictedCategorySet = new CategorySet();
        if (categories != null) {
            Iterator iterator = categories.iterator();
            while (iterator.hasNext()) {
                Category category;
                Category firstLevelCategory = category = (Category)iterator.next();
                if (category.getParentCategory() != null) {
                    firstLevelCategory = category.getRootCategory();
                }
                Category restrictedCategory = new Category(firstLevelCategory);
                AlgorithmManagementProxy.updateRestrictedAlgorithms(restrictedCategory, algoOperation);
                AlgorithmManagementProxy.updateRestrictedCategories(restrictedCategory, restrictedCategory.getCategories().iterator(), algoOperation);
                Category modifiedCategory = restrictedCategory;
                if (category != firstLevelCategory) {
                    modifiedCategory = restrictedCategory.getCategory(category.getId());
                }
                restrictedCategorySet.addCategory(modifiedCategory);
            }
        }
        return restrictedCategorySet;
    }

    private static boolean isAlgorithmOwnerUser(AlgorithmInfo algoInfo) {
        String algorithmOwner = algoInfo.getOwner();
        User user = User.getLoggedUser();
        return AlgorithmManagementProxy.isAdminLoggedUser() || algorithmOwner != null && algorithmOwner.equals(user.getLogin());
    }

    private static boolean isAdminLoggedUser() {
        User user = User.getLoggedUser();
        return user.isAdmin();
    }

    private static void updateRestrictedAlgorithms(Category category, AlgorithmOperation algoOperation) {
        Set algorithms = category.getAlgorithms();
        Iterator algorithmIterator = algorithms.iterator();
        while (algorithmIterator.hasNext()) {
            AlgorithmInfo algoInfo = (AlgorithmInfo)algorithmIterator.next();
            if (AlgorithmManagementProxy.isAlgorithmOwnerUser(algoInfo)) continue;
            if (AlgorithmManagementProxy.isAdminOperation(algoOperation)) {
                if (AlgorithmManagementProxy.hasAlgorithmAdminPermission(algoInfo)) continue;
                algorithmIterator.remove();
                continue;
            }
            if (!AlgorithmManagementProxy.isExecuteOperation(algoOperation) || AlgorithmManagementProxy.hasAlgorithmExecutePermission(algoInfo) || AlgorithmManagementProxy.hasAlgorithmExecutePermissionByCategory(algoInfo, category.getFullName())) continue;
            algorithmIterator.remove();
        }
    }

    private static void updateRestrictedCategories(Category restrictedCategory, Iterator<Category> catIterator, AlgorithmOperation algoOperation) {
        TreeSet<Category> newCategories = new TreeSet<Category>();
        while (catIterator.hasNext()) {
            Category category = catIterator.next();
            Category newCategory = new Category(category);
            newCategory.setParentCategory(restrictedCategory);
            catIterator.remove();
            newCategories.add(newCategory);
            AlgorithmManagementProxy.updateRestrictedAlgorithms(newCategory, algoOperation);
            AlgorithmManagementProxy.updateRestrictedCategories(newCategory, newCategory.getCategories().iterator(), algoOperation);
        }
        restrictedCategory.setCategories(newCategories);
    }

    private static void checkAlgorithmAdminPermission(AlgorithmInfo algoInfo) throws Exception {
        if (algoInfo == null) {
            throw new IllegalArgumentException(AlgorithmManagementProxy.getParameterNullMessage("algoInfo"));
        }
        if (AlgorithmManagementProxy.isAdminLoggedUser()) {
            return;
        }
        String algoAttribute = "algoritmo=" + algoInfo.getName();
        User user = User.getLoggedUser();
        AlgorithmAdminPermission ap = (AlgorithmAdminPermission)user.getMatchAttributesPermission(AlgorithmAdminPermission.class, algoAttribute);
        if (ap == null) {
            throw new PermissionException(AlgorithmManagementProxy.getAlgoAdminPermissionErrorMessage(algoInfo.getName()));
        }
        String serverName = AlgorithmManagementProxy.getServerName();
        String name = "local=" + serverName;
        if (ap.getMatchAttribute(name) == null) {
            throw new PermissionException(AlgorithmManagementProxy.getAlgoAdminServerPermissionErrorMessage(serverName));
        }
    }

    private static void checkAlgorithmExecutePermission(AlgorithmInfo algoInfo, CategorySet categorySet) throws Exception {
        if (algoInfo == null) {
            throw new IllegalArgumentException(AlgorithmManagementProxy.getParameterNullMessage("algoInfo"));
        }
        if (AlgorithmManagementProxy.isAdminLoggedUser()) {
            return;
        }
        String systemId = null;
        String algorithmName = algoInfo.getName();
        List categoriesFullNames = categorySet.getAlgorithmCategoriesFullNames(algoInfo);
        if (AlgorithmExecutionPermission.checkSystemAndAlgorithmExecPermission((User)User.getLoggedUser(), systemId, (String)algorithmName)) {
            return;
        }
        if (CategoryAlgorithmsExecutionPermission.checkSystemAndCategoriesExecPermission((User)User.getLoggedUser(), systemId, (List)categoriesFullNames)) {
            return;
        }
        throw new PermissionException(AlgorithmManagementProxy.getAlgoExecutePermissionErrorMessage(algorithmName));
    }

    private static boolean hasAlgorithmAdminPermission(AlgorithmInfo algoInfo) {
        if (algoInfo == null) {
            throw new IllegalArgumentException(AlgorithmManagementProxy.getParameterNullMessage("algoInfo"));
        }
        boolean hasPermission = true;
        if (!AlgorithmManagementProxy.isAdminLoggedUser()) {
            try {
                AlgorithmManagementProxy.checkAlgorithmAdminPermission(algoInfo);
            }
            catch (Exception e) {
                hasPermission = false;
            }
        }
        return hasPermission;
    }

    private static boolean hasAlgorithmExecutePermission(AlgorithmInfo algoInfo) {
        if (algoInfo == null) {
            throw new IllegalArgumentException(AlgorithmManagementProxy.getParameterNullMessage("algoInfo"));
        }
        boolean hasPermission = true;
        try {
            if (AlgorithmManagementProxy.isAdminLoggedUser() || AlgorithmManagementProxy.isAlgorithmOwnerUser(algoInfo)) {
                return true;
            }
            String systemId = null;
            hasPermission = AlgorithmExecutionPermission.checkSystemAndAlgorithmExecPermission((User)User.getLoggedUser(), systemId, (String)algoInfo.getName());
        }
        catch (Exception e) {
            hasPermission = false;
        }
        return hasPermission;
    }

    private static boolean hasAlgorithmExecutePermissionByCategory(AlgorithmInfo algoInfo, String categoryFullName) {
        boolean hasPermission = true;
        try {
            if (AlgorithmManagementProxy.isAdminLoggedUser() || AlgorithmManagementProxy.isAlgorithmOwnerUser(algoInfo)) {
                return true;
            }
            String systemId = null;
            hasPermission = CategoryAlgorithmsExecutionPermission.checkSystemAndCategoryExecPermission((User)User.getLoggedUser(), systemId, (String)categoryFullName);
        }
        catch (Exception e) {
            hasPermission = false;
        }
        return hasPermission;
    }

    private static String getParameterNullMessage(String parameter) {
        String msg = LNG.get((String)"AlgorithmManagementProxy.error.parameter.null");
        Object[] args = new Object[]{parameter};
        return MessageFormat.format(msg, args);
    }

    private static String getAlgoExecutePermissionErrorMessage(String algoName) {
        String msg = LNG.get((String)"AlgorithmManagementProxy.error.algo.execute.no_permission");
        Object[] args = new Object[]{algoName};
        return MessageFormat.format(msg, args);
    }

    private static String getAlgoAdminPermissionErrorMessage(String algoName) {
        String msg = LNG.get((String)"AlgorithmManagementProxy.error.algo.admin.no_permission");
        Object[] args = new Object[]{algoName};
        return MessageFormat.format(msg, args);
    }

    private static String getAlgoAdminServerPermissionErrorMessage(String serverName) {
        String msg = LNG.get((String)"AlgorithmManagementProxy.error.algo.admin.server.no_permission");
        Object[] args = new Object[]{serverName};
        return MessageFormat.format(msg, args);
    }

    private static void mapAlgorithmsToCategories() {
        algorithmToCategoryMap.clear();
        for (Category category : categorySet.getAllCategories()) {
            for (AlgorithmInfo algo : allAlgorithmInfo) {
                if (!category.containsAlgorithm(algo)) continue;
                if (!algorithmToCategoryMap.containsKey(algo)) {
                    algorithmToCategoryMap.put(algo, new TreeSet());
                }
                algorithmToCategoryMap.get(algo).add(category);
            }
        }
    }

    private static void mapCategoryAlgorithms(Category category) {
        Set algorithms = category.getAlgorithms();
        for (AlgorithmInfo algorithmInfo : algorithms) {
            if (!algorithmToCategoryMap.containsKey(algorithmInfo)) {
                algorithmToCategoryMap.put(algorithmInfo, new TreeSet());
            }
            algorithmToCategoryMap.get(algorithmInfo).add(category);
        }
        AlgorithmManagementProxy.mapSubCategoriesAlgorithms(category.getCategories());
    }

    private static void unmapCategoryAlgorithms(String categoryId) {
        Category category = categorySet.getCategory(categoryId);
        Set algorithms = category.getAlgorithms();
        for (AlgorithmInfo algorithmInfo : algorithms) {
            if (!algorithmToCategoryMap.containsKey(algorithmInfo)) continue;
            SortedSet<Category> categoryset = algorithmToCategoryMap.get(algorithmInfo);
            categoryset.remove(category);
        }
        AlgorithmManagementProxy.unmapSubCategoriesAlgorithms(category.getCategories());
    }

    private static void mapSubCategoriesAlgorithms(SortedSet<Category> subCategories) {
        for (Category subCat : subCategories) {
            AlgorithmManagementProxy.mapCategoryAlgorithms(subCat);
        }
    }

    private static void unmapSubCategoriesAlgorithms(SortedSet<Category> subCategories) {
        for (Category subCat : subCategories) {
            AlgorithmManagementProxy.unmapCategoryAlgorithms(subCat.getId());
        }
    }

    private static void mapAlgorithmCategories(AlgorithmInfo algoInfo) {
        if (!algorithmToCategoryMap.containsKey(algoInfo)) {
            algorithmToCategoryMap.put(algoInfo, new TreeSet());
        }
    }

    private static void unmapAlgorithmCategories(AlgorithmInfo algoInfo) {
        if (algorithmToCategoryMap.containsKey(algoInfo)) {
            SortedSet<Category> categories = algorithmToCategoryMap.get(algoInfo);
            for (Category category : categories) {
                category.removeAlgorithm(algoInfo);
            }
            algorithmToCategoryMap.remove(algoInfo);
        }
    }

    public static SortedSet<Category> getAlgorithmCategories(Window owner, AlgorithmOperation algoOperation, AlgorithmInfo algorithmInfo) {
        SortedSet<Category> categories = algorithmToCategoryMap.get(algorithmInfo);
        if (AlgorithmManagementProxy.isExecuteOperation(algoOperation) && !AlgorithmManagementProxy.isAdminLoggedUser()) {
            return AlgorithmManagementProxy.getRestrictedCategories(categories, algoOperation).getCategories();
        }
        return categories;
    }

    private static boolean isExecuteOperation(AlgorithmOperation algoOperation) {
        return algoOperation.equals((Object)AlgorithmOperation.EXECUTE_ALGORITHM);
    }

    private static boolean isAdminOperation(AlgorithmOperation algoOperation) {
        return algoOperation.equals((Object)AlgorithmOperation.ADMIN_ALGORITHM);
    }

    public static void updateAlgorithmsCache(AlgorithmInfo[] algoInfos) {
        allAlgorithmInfo.clear();
        for (AlgorithmInfo algorithmInfo : algoInfos) {
            allAlgorithmInfo.add(algorithmInfo);
        }
        AlgorithmManagementProxy.mapAlgorithmsToCategories();
        hasAllAlgorithms = true;
    }

    public static void updateCategoriesCache(CategorySet categorySet) {
        AlgorithmManagementProxy.categorySet = categorySet;
        AlgorithmManagementProxy.mapAlgorithmsToCategories();
        hasAllCategories = true;
    }

    private static void removeAlgorithm(AlgorithmInfo algoInfo) {
        allAlgorithmInfo.remove(algoInfo);
        AlgorithmManagementProxy.unmapAlgorithmCategories(algoInfo);
    }

    private static void createAlgorithm(AlgorithmInfo algoInfo) {
        allAlgorithmInfo.add(algoInfo);
        AlgorithmManagementProxy.mapAlgorithmCategories(algoInfo);
    }

    private static void updateAlgorithm(AlgorithmInfo algoInfo) {
        AlgorithmManagementProxy.removeAlgorithm(algoInfo);
        AlgorithmManagementProxy.createAlgorithm(algoInfo);
    }

    private static void removeCategory(String categoryId) {
        Category category = categorySet.getCategory(categoryId);
        if (category == null) {
            return;
        }
        AlgorithmManagementProxy.unmapCategoryAlgorithms(category.getId());
        Category parentCategory = null;
        parentCategory = category.getParentCategory();
        if (parentCategory == null) {
            categorySet.removeCategory(categoryId);
        } else {
            parentCategory.removeCategory(category);
        }
    }

    private static void createCategory(Category category) {
        Category parentCategory = null;
        parentCategory = category.getParentCategory();
        if (parentCategory == null) {
            AlgorithmManagementProxy.removeCategory(category.getId());
            categorySet.addCategory(category);
            AlgorithmManagementProxy.mapCategoryAlgorithms(category);
        } else {
            Category rootCreatedCategory = AlgorithmManagementProxy.getRootCategory(parentCategory);
            Category oldCategory = categorySet.getRootCategory(rootCreatedCategory.getId());
            if (oldCategory != null) {
                AlgorithmManagementProxy.removeCategory(oldCategory.getId());
            }
            categorySet.addCategory(rootCreatedCategory);
            AlgorithmManagementProxy.mapCategoryAlgorithms(rootCreatedCategory);
        }
    }

    private static void updateCategory(Category category) {
        AlgorithmManagementProxy.createCategory(category);
    }

    private static void updateCategories(CategorySet modifiedCategorySet) {
        for (Category category : modifiedCategorySet.getCategories()) {
            AlgorithmManagementProxy.updateCategory(category);
        }
    }

    private static Category getRootCategory(Category category) {
        Category parent = category.getParentCategory();
        if (parent == null) {
            return category;
        }
        return AlgorithmManagementProxy.getRootCategory(parent);
    }

    public static void addManagementListener(AlgorithmManagementListener listener) {
        if (!managementList.contains(listener)) {
            managementList.add(listener);
        }
    }

    public static void removeManagementListener(AlgorithmManagementListener listener) {
        managementList.remove(listener);
    }

    private static void notifyCategoryCreated(Category category) {
        for (AlgorithmManagementListener listener : managementList) {
            listener.categoryCreated(category);
        }
    }

    private static void notifyCategoryRemoved(Category category) {
        for (AlgorithmManagementListener listener : managementList) {
            listener.categoryRemoved(category);
        }
    }

    private static void notifyCategoryUpdated(CategorySet modifiedCategorySet) {
        for (AlgorithmManagementListener listener : managementList) {
            listener.categoryUpdated(modifiedCategorySet);
        }
    }

    private static void notifyAlgorithmsReloaded() {
        for (AlgorithmManagementListener listener : managementList) {
            listener.algorithmsReloaded();
        }
    }

    private static void notifyAlgorithmCreated(AlgorithmInfo algoInfo) {
        for (AlgorithmManagementListener listener : managementList) {
            listener.algorithmCreated(algoInfo);
        }
    }

    private static void notifyAlgorithmRemoved(AlgorithmInfo algoInfo) {
        for (AlgorithmManagementListener listener : managementList) {
            listener.algorithmRemoved(algoInfo);
        }
    }

    private static void notifyAlgorithmUpdated(AlgorithmInfo algoInfo) {
        for (AlgorithmManagementListener listener : managementList) {
            listener.algorithmUpdated(algoInfo);
        }
    }

    public static void handleCategoryEvent(final AlgoEvent event) {
        final Category category = event.item instanceof Category ? (Category)event.item : null;
        switch (event.type) {
            case 1: {
                SwingThreadDispatcher.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        AlgorithmManagementProxy.prepareCacheReload();
                        AlgorithmManagementProxy.notifyCategoryCreated(category);
                    }
                });
                break;
            }
            case 3: {
                SwingThreadDispatcher.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        AlgorithmManagementProxy.prepareCacheReload();
                        AlgorithmManagementProxy.notifyCategoryRemoved(category);
                    }
                });
                break;
            }
            case 2: {
                if (!(event.item instanceof CategorySet)) break;
                SwingThreadDispatcher.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        CategorySet modifiedCategorySet = (CategorySet)event.item;
                        AlgorithmManagementProxy.prepareCacheReload();
                        AlgorithmManagementProxy.notifyCategoryUpdated(modifiedCategorySet);
                    }
                });
                break;
            }
        }
    }

    private static void handleAlgorithmEvent(AlgoEvent event) {
        final AlgorithmInfo algoInfo = event.item instanceof AlgorithmInfo ? (AlgorithmInfo)event.item : null;
        switch (event.type) {
            case 1: {
                SwingThreadDispatcher.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        AlgorithmManagementProxy.prepareCacheReload();
                        AlgorithmManagementProxy.notifyAlgorithmCreated(algoInfo);
                    }
                });
                break;
            }
            case 3: {
                SwingThreadDispatcher.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        AlgorithmManagementProxy.prepareCacheReload();
                        AlgorithmManagementProxy.notifyAlgorithmRemoved(algoInfo);
                    }
                });
                break;
            }
            case 2: {
                SwingThreadDispatcher.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        AlgorithmManagementProxy.prepareCacheReload();
                        AlgorithmManagementProxy.notifyAlgorithmUpdated(algoInfo);
                    }
                });
                break;
            }
            case 4: {
                SwingThreadDispatcher.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        AlgorithmManagementProxy.prepareCacheReload();
                        AlgorithmManagementProxy.notifyAlgorithmsReloaded();
                    }
                });
                break;
            }
        }
    }

    private static void addCategoryEventsObserver() {
        Category.addObserver((Observer)new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                AlgoEvent event = (AlgoEvent)arg;
                AlgorithmManagementProxy.handleCategoryEvent(event);
            }
        });
    }

    private static void addCategorySetEventsObserver() {
        CategorySet.addObserver((Observer)new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                AlgoEvent event = (AlgoEvent)arg;
                AlgorithmManagementProxy.handleCategoryEvent(event);
            }
        });
    }

    private static void addAlgorithmEventsObserver() {
        AlgorithmInfo.addObserver((Observer)new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                AlgoEvent event = (AlgoEvent)arg;
                AlgorithmManagementProxy.handleAlgorithmEvent(event);
            }
        });
    }

    static {
        managementList = new Vector<AlgorithmManagementListener>();
        hasAllAlgorithms = false;
        hasAllCategories = false;
        categorySet = new CategorySet();
        allAlgorithmInfo = new TreeSet<AlgorithmInfo>();
        algorithmToCategoryMap = new HashMap();
        AlgorithmManagementProxy.addCategoryEventsObserver();
        AlgorithmManagementProxy.addCategorySetEventsObserver();
        AlgorithmManagementProxy.addAlgorithmEventsObserver();
        AlgorithmManagementProxy.addServerMonitorListener();
    }

    public static enum AlgorithmOperation {
        ADMIN_ALGORITHM,
        EXECUTE_ALGORITHM,
        ANY;

    }
}

