package csbase.client.applications.algorithmsmanager.report.core;

import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

import tecgraf.javautils.gui.GBC;

/**
 * Painel para seleo de testes
 *
 *
 * @author Tecgraf/PUC-Rio
 */
public class TestSelectionPanel extends JPanel {

  /** Lista de escutadores das selees */
  List<ItemListener> listeners = new ArrayList<>();

  /** Classe que associa um teste a um checkBox */
  static class TestCheckbox {
    /** Checkbox */
    public JCheckBox checkBox;
    /** Test */
    public ITest<?> test;

    /**
     * Construtor
     *
     * @param test Teste para o qual ser associado um checkbox
     */
    public TestCheckbox(ITest<?> test) {
      super();
      this.checkBox = new JCheckBox(test.getName());
      this.test = test;
    }
  }

  /** Lista de checkBoxes das op??es */
  private final List<TestCheckbox> checkBoxes = new ArrayList<>();

  /**
   * Constri o dilogo
   *
   * @param tests lista de testes.
   */
  TestSelectionPanel(List<ITest<?>> tests) {

    // Op??es
    JPanel checkBoxPanel = new JPanel(new GridBagLayout());
    int y = 0;
    int x = 0;
    for (ITest<?> test : tests) {
      TestCheckbox testCheckBox = new TestCheckbox(test);
      checkBoxes.add(testCheckBox);
      testCheckBox.checkBox.setSelected(true);
      testCheckBox.checkBox.addItemListener(e -> callListeners(e));
      checkBoxPanel.add(testCheckBox.checkBox, new GBC(x, y).insets(3, 0, 0, 0)
        .horizontal());
      y += x;
      x = (x + 1) % 2;
    }

    // Composi??o
    JScrollPane scroll = new JScrollPane(checkBoxPanel);
    scroll.setBorder(null);

    setLayout(new GridBagLayout());
    add(scroll, new GBC(0, 0).both().center().insets(0, 0, 0, 0));
  }

  /**
   * Avisa de mudanas na seleo
   *
   * @param e Evento
   */
  private void callListeners(ItemEvent e) {
    listeners.forEach(l -> l.itemStateChanged(e));
  }

  /**
   * Obt?m a sele??o
   *
   * @return Lista com mesmo tamanho da lista de testes passado no construtor
   *         indicando com verdadeiro ou falso se o teste foi selecionado
   */
  public List<ITest<?>> getSelection() {

    List<ITest<?>> tests =
      checkBoxes.stream().filter(c -> c.checkBox.isSelected()).map(c -> c.test)
      .collect(Collectors.toList());

    return tests;
  }

  /**
   * Adiciona um listener para escutar as selees
   *
   * @param l Listener
   */
  public void addItemListener(ItemListener l) {
    listeners.add(l);
  }

  /**
   * Remove um listener que estava escutando as selees
   *
   * @param l Listener
   */
  public void removeItemListener(ItemListener l) {
    listeners.remove(l);
  }

}
