/*
 * $Id: RefreshLocalAction.java 88652 2009-02-20 04:45:52Z clinio $
 */

package csbase.client.applications.filetransferclient.actions;

import javax.swing.ImageIcon;
import javax.swing.JComponent;

import csbase.client.applications.ApplicationImages;
import csbase.client.applications.filetransferclient.FileTransferClient;
import csbase.client.applications.filetransferclient.actions.core.FileTransferClientAction;
import csbase.client.applications.filetransferclient.panels.queuepanel.FileTransferClientQueuePanel;

/**
 * Ao de refrescamento do painel de arquivos locais.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class RefreshQueueTableAction extends FileTransferClientAction {

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionDone(final JComponent component) {
    final FileTransferClient app = getApplication();
    final FileTransferClientQueuePanel queuePanel = app.getQueuePanel();
    queuePanel.refresh();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ImageIcon getStandardImageIcon() {
    return ApplicationImages.ICON_REFRESH_16;
  }

  /**
   * Construtor
   * 
   * @param application aplicao
   */
  public RefreshQueueTableAction(final FileTransferClient application) {
    super(application);
  }
}
