package csbase.client.applications.flowapplication.zoom;

import javax.swing.AbstractSpinnerModel;

/**
 * <p>
 * Modelo de zoom para spinner.
 * </p>
 * 
 * <p>
 * Classe que adequa a modelos de zoom para ser usados como modelos para
 * spinners.
 * </p>
 * 
 * @author lmoreira.
 */
public final class ZoomSpinnerModel extends AbstractSpinnerModel {
  /**
   * Modelo.
   */
  private final ZoomModel zoomModel;

  /**
   * Cria um modelo de zoom para spinner.
   * 
   * @param zoomModel O modelo de zoom.
   */
  public ZoomSpinnerModel(final ZoomModel zoomModel) {
    this.zoomModel = zoomModel;
    this.zoomModel.addListener(new ZoomSpinnerModelListener());
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object getNextValue() {
    return toSpinnerValue(this.zoomModel.getNextUnitValue());
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object getPreviousValue() {
    return toSpinnerValue(this.zoomModel.getPreviousUnitValue());
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object getValue() {
    return toSpinnerValue(this.zoomModel.getValue());
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void setValue(final Object value) {
    this.zoomModel.setValue(fromSpinnerValue(value));
  }

  /**
   * Converte o valor vindo do spinner para o valor utilizado no modelo de zoom.
   * 
   * @param zoomValue O valor do spinner.
   * 
   * @return .
   */
  private static double fromSpinnerValue(final Object zoomValue) {
    final String stringValue = (String) zoomValue;
    return Integer.parseInt(stringValue) / 100.0;
  }

  /**
   * Converte o valor do modelo de zoom para o valor utilizado no spinner.
   * 
   * @param zoomValue O valor de zoom.
   * 
   * @return O valor convertido.
   */
  private static Object toSpinnerValue(final double zoomValue) {
    final int intValue = (int) Math.round((zoomValue * 100));
    return Integer.toString(intValue);
  }

  /**
   * O listener de zoom que comunica ao modelo de zoom para spinners sobre
   * mudanas de zoom.
   */
  private class ZoomSpinnerModelListener implements ZoomListener {
    /**
     * {@inheritDoc}
     */
    @Override
    public void wasChanged(final ZoomModel model) {
      fireStateChanged();
    }
  }
}
