package csbase.client.applications.projectsmanager.dialogs.core;

import javax.swing.WindowConstants;

import csbase.client.applications.ApplicationComponentDialog;
import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.ProjectsManagerUI;

/**
 * Dilogo da aplicao.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class ProjectsManagerDialog extends
  ApplicationComponentDialog<ProjectsManager> {

  /**
   * Aplicao.
   */
  final private ProjectsManager projectsManager;

  /**
   * Busca texto de internacionalizao
   * 
   * @param tag o rtulo
   * @return o texto
   */
  //  @Override
  //  final public String getString(final String tag) {
  //    final Class<? extends ProjectsManagerDialog> clazz = this.getClass();
  //    final String text = ProjectsManagerUI.getString(clazz, tag);
  //    return text;
  //  }

  /**
   * Consulta o valor de projectsManager
   * 
   * @return o valor
   */
  public final ProjectsManager getProjectsManager() {
    return projectsManager;
  }

  /**
   * Construtor
   * 
   * @param projectsManager a aplicao.
   */
  public ProjectsManagerDialog(final ProjectsManager projectsManager) {
    super(projectsManager);

    this.projectsManager = projectsManager;

    setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);

    final Class<? extends ProjectsManagerDialog> clazz = this.getClass();
    final String titleTag = "dialog.title";
    final boolean hasTitle = ProjectsManagerUI.hasClassString(clazz, titleTag);
    if (hasTitle) {
      final String title = ProjectsManagerUI.getClassString(clazz, titleTag);
      setTitle(title);
    }
  }

}
