/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.filechooser;

import csbase.client.util.filechooser.ClientFileChooser;
import csbase.client.util.filechooser.ClientFileChooserType;
import csbase.client.util.filechooser.filetablepanel.ClientFileTablePanel;
import csbase.client.util.filechooser.filetablepanel.ClientFileTableSelectionListener;
import csbase.client.util.filechooser.filters.ClientFileFilterInterface;
import csbase.logic.ClientFile;
import java.util.ArrayList;
import java.util.List;

class ClientFileChooserSelectionListener
implements ClientFileTableSelectionListener {
    private final ClientFileChooser chooser;

    @Override
    public void selectionPerformed(ClientFileTablePanel panel, List<ClientFile> selectionList) {
        ClientFileChooserType type = this.chooser.getSelectionType();
        switch (type) {
            case SAVE: {
                this.handleSaveType(selectionList);
                break;
            }
            case OPEN: {
                this.handleOpenType(selectionList);
            }
        }
    }

    private void handleSaveType(List<ClientFile> selectionList) {
        if (selectionList.size() == 0) {
            this.clearSelection();
            return;
        }
        ClientFile selection = selectionList.get(0);
        boolean flag = false;
        if (this.chooser.getSelectedFilter().accept(selection, ClientFileFilterInterface.Operation.SELECTION)) {
            switch (this.chooser.getSelectionMode()) {
                case FILES_ONLY: {
                    if (selection.isDirectory()) break;
                    flag = true;
                    break;
                }
                case DIRECTORIES_ONLY: {
                    if (!selection.isDirectory()) break;
                    flag = true;
                    break;
                }
                default: {
                    String message = String.format("Modo inv\u00e1lido: %s.\n", new Object[]{this.chooser.getSelectionMode()});
                    throw new IllegalStateException(message);
                }
            }
        }
        if (flag) {
            ArrayList<ClientFile> uniq = new ArrayList<ClientFile>();
            uniq.add(selection);
            this.chooser.setChosenItens(uniq);
        } else {
            this.clearSelection();
        }
    }

    private void clearSelection() {
        ArrayList<ClientFile> empty = new ArrayList<ClientFile>();
        this.chooser.setChosenItens(empty);
    }

    private void handleOpenType(List<ClientFile> selectionList) {
        ArrayList<ClientFile> realList = new ArrayList<ClientFile>();
        block4: for (ClientFile file : selectionList) {
            if (!this.chooser.getSelectedFilter().accept(file, ClientFileFilterInterface.Operation.SELECTION)) continue;
            switch (this.chooser.getSelectionMode()) {
                case FILES_ONLY: {
                    if (file.isDirectory()) continue block4;
                    realList.add(file);
                    continue block4;
                }
                case DIRECTORIES_ONLY: {
                    if (!file.isDirectory()) continue block4;
                    realList.add(file);
                    continue block4;
                }
            }
            String message = String.format("Modo inv\u00e1lido: %s.\n", new Object[]{this.chooser.getSelectionMode()});
            throw new IllegalStateException(message);
        }
        this.chooser.setChosenItens(realList);
    }

    ClientFileChooserSelectionListener(ClientFileChooser chooser) {
        this.chooser = chooser;
    }
}

