/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.ias;

import csbase.client.desktop.DesktopComponentDialog;
import csbase.client.util.ClientUtilities;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.MDigest;
import csbase.logic.User;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.security.DigestException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GUIUtils;

public class IncludePasswordDialog {
    private DesktopComponentDialog window;
    private String windowLabel;
    private JTextField oldPasswordField;
    private JTextField newPasswordField;
    private JTextField newPasswordConfirmField;
    private String newPassword;
    private boolean isNew;
    private boolean loggedUserIsAdmin;
    private User user;

    public String getNewPassword() {
        return this.newPassword;
    }

    private void display(DesktopComponentDialog owner) {
        JPanel pane = new JPanel(new BorderLayout());
        pane.add((Component)this.makeTextPanel(), "North");
        pane.add((Component)this.makeButtonPanel(), "South");
        this.window = new DesktopComponentDialog((Window)owner, this.windowLabel);
        this.window.getContentPane().add(pane);
        this.window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                IncludePasswordDialog.this.window.dispose();
            }
        });
        this.window.pack();
        this.window.center(owner);
        this.window.setVisible(true);
    }

    private JPanel makeTextPanel() {
        this.oldPasswordField = new JPasswordField(12);
        this.newPasswordField = new JPasswordField(12);
        this.newPasswordConfirmField = new JPasswordField(12);
        JPanel mainPanel = new JPanel();
        JPanel labelsPanel = new JPanel(new GridLayout(0, 1));
        JPanel fieldsPanel = new JPanel(new GridLayout(0, 1));
        mainPanel.add(labelsPanel);
        mainPanel.add(fieldsPanel);
        if (this.isNew) {
            labelsPanel.add(new JLabel(LNG.get((String)"IAS_USER_NEW_PASSWORD")));
            fieldsPanel.add(this.newPasswordField);
            labelsPanel.add(new JLabel(LNG.get((String)"IAS_USER_PASSWORD_CONFIRMATION")));
            fieldsPanel.add(this.newPasswordConfirmField);
        } else if (this.loggedUserIsAdmin) {
            labelsPanel.add(new JLabel(LNG.get((String)"IAS_USER_NEW_PASSWORD")));
            fieldsPanel.add(this.newPasswordField);
            labelsPanel.add(new JLabel(LNG.get((String)"IAS_USER_NEW_PASSWORD_CONFIRMATION")));
            fieldsPanel.add(this.newPasswordConfirmField);
        } else {
            labelsPanel.add(new JLabel(LNG.get((String)"IAS_USER_CURRENT_PASSWORD")));
            fieldsPanel.add(this.oldPasswordField);
            labelsPanel.add(new JLabel(LNG.get((String)"IAS_USER_NEW_PASSWORD")));
            fieldsPanel.add(this.newPasswordField);
            labelsPanel.add(new JLabel(LNG.get((String)"IAS_USER_NEW_PASSWORD_CONFIRMATION")));
            fieldsPanel.add(this.newPasswordConfirmField);
        }
        return mainPanel;
    }

    private JPanel makeButtonPanel() {
        JButton okB = new JButton(LNG.get((String)"IAS_CONFIRM"));
        okB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                try {
                    if (IncludePasswordDialog.this.validateFields()) {
                        IncludePasswordDialog.this.window.dispose();
                    } else {
                        StandardErrorDialogs.showErrorDialog((Window)IncludePasswordDialog.this.window, IncludePasswordDialog.this.windowLabel, LNG.get((String)"IAS_USER_PASSWORD_ERROR"));
                    }
                }
                catch (DigestException e) {
                    StandardErrorDialogs.showErrorDialog(IncludePasswordDialog.this.window, IncludePasswordDialog.this.windowLabel, LNG.get((String)"IAS_USER_DIGEST_PASSWORD_ERROR"), e);
                }
            }
        });
        JButton clearB = new JButton(LNG.get((String)"IAS_CLEAR"));
        clearB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                IncludePasswordDialog.this.clearFields();
            }
        });
        JButton cancelB = new JButton(LNG.get((String)"IAS_CANCEL"));
        cancelB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                IncludePasswordDialog.this.window.dispose();
            }
        });
        JPanel buttonP = new JPanel();
        buttonP.add(okB);
        buttonP.add(clearB);
        buttonP.add(cancelB);
        GUIUtils.matchPreferredSizes((JComponent[])new JComponent[]{okB, clearB, cancelB});
        return buttonP;
    }

    protected boolean newPasswordIsValid() {
        String password = this.newPasswordField.getText();
        String confirmation = this.newPasswordConfirmField.getText();
        return !password.equals("") && !confirmation.equals("") && password.equals(confirmation);
    }

    protected boolean checkOldPassword() throws DigestException {
        String old = this.oldPasswordField.getText();
        String oldDigest = MDigest.getDigest((String)old);
        return this.user.getPasswordDigest().equals(oldDigest);
    }

    protected boolean validateFields() throws DigestException {
        if (this.isNew || this.loggedUserIsAdmin) {
            if (this.newPasswordIsValid()) {
                this.newPassword = this.newPasswordField.getText();
                return true;
            }
            return false;
        }
        if (this.checkOldPassword() && this.newPasswordIsValid()) {
            this.newPassword = this.newPasswordField.getText();
            return true;
        }
        return false;
    }

    protected void clearFields() {
        if (!this.isNew && !this.loggedUserIsAdmin) {
            this.oldPasswordField.setText("");
            this.oldPasswordField.requestFocus();
        } else {
            this.newPasswordField.requestFocus();
        }
        this.newPasswordField.setText("");
        this.newPasswordConfirmField.setText("");
    }

    public IncludePasswordDialog(DesktopComponentDialog owner) {
        this.user = null;
        this.isNew = true;
        this.loggedUserIsAdmin = User.getLoggedUser().isAdmin();
        this.windowLabel = LNG.get((String)"IAS_USER_PASSWORD_REGISTRATION_TITLE");
        this.display(owner);
    }

    public IncludePasswordDialog(DesktopComponentDialog owner, User user) {
        this.user = user;
        this.isNew = false;
        this.loggedUserIsAdmin = User.getLoggedUser().isAdmin();
        this.windowLabel = ClientUtilities.addSystemNameToTitle(LNG.get((String)"ias.user.password_update_title"));
        this.display(owner);
    }
}

