/*
 * $Id: AbstractNumberTextFieldModel.java 157822 2014-10-30 13:25:28Z
 * pietroguedes $
 */
package csbase.client.algorithms.parameters;

import java.util.LinkedList;
import java.util.List;

/**
 * Modelo de campo de texto nmero abstrato.
 *
 * @param <N> O tipo do nmero.
 *
 * @author Tecgraf/PUC-Rio
 */
public abstract class AbstractNumberTextFieldModel<N extends Number> implements
NumberTextFieldModel<N> {
  /**
   * Os observadores.
   */
  private List<NumberTextFieldModelListener> listeners;

  /**
   * O valor usado para indicar erro.
   */
  private N errorValue;

  /**
   * Cria o modelo.
   *
   * @param errorValue o valor usado para indicar erro.
   */
  protected AbstractNumberTextFieldModel(N errorValue) {
    this.errorValue = errorValue;
    this.listeners = new LinkedList<NumberTextFieldModelListener>();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public final void addNumberTextFieldModelListener(
    NumberTextFieldModelListener listener) {
    if (listener == null) {
      throw new IllegalArgumentException("O parmetro listener est nulo.");
    }
    this.listeners.add(listener);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public final boolean removeNumberTextFieldListener(
    NumberTextFieldModelListener listener) {
    if (listener == null) {
      throw new IllegalArgumentException("O parmetro listener est nulo.");
    }
    return this.listeners.remove(listener);
  }

  /**
   * Dispara o evento de mudana de valor.
   */
  protected final void fireChangedValue() {
    for (NumberTextFieldModelListener listener : this.listeners) {
      listener.wasChangedValue();
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public final N getErrorValue() {
    return errorValue;
  }
}
