/*
 * $Id$
 */

package csbase.client.applications.algorithmsmanager.versiontree;

import java.awt.datatransfer.DataFlavor;
import java.util.ArrayList;
import java.util.List;

import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

import csbase.client.applications.ApplicationImages;
import csbase.client.applications.algorithmsmanager.versiontree.AbstractFileInfoNode.DataTransferObject;
import csbase.client.applications.algorithmsmanager.versiontree.actions.ImportDocumentationFile;
import csbase.client.applications.algorithmsmanager.versiontree.actions.PasteFile;
import csbase.client.applications.algorithmsmanager.versiontree.actions.VersionWarningActionDecorator;
import csbase.client.applications.algorithmsmanager.versiontree.datatransfer.ITransferableTarget;
import csbase.client.remote.srvproxies.AlgorithmManagementProxy;
import csbase.logic.FileInfo;
import csbase.logic.IPathFactory;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.logic.algorithms.DocumentationPathFactory;
import tecgraf.javautils.core.lng.LNG;

/**
 * @author Tecgraf / PUC-Rio
 * 
 *         N raiz da sub-rvore de documentao de uma verso de um algortmo.
 */
final class DocumentationNode extends AbstractVersionTreeNode implements
  ITransferableTarget {

  /**
   * Verso cuja lista de arquivos de documentao  representada por este n.
   */
  private AlgorithmVersionInfo version;

  /**
   * Construtor.
   * 
   * @param tree rvore que detm este n.
   * @param version Verso cuja lista de arquivos de documentao  representada
   *        por este n.
   */
  public DocumentationNode(VersionTree tree, AlgorithmVersionInfo version) {
    super(tree, version.getDocumentationDirName());

    this.version = version;

    for (FileInfo file : version.getDocumentation()) {
      add(new DocumentationFileNode(tree, version, file));
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ImageIcon getImageIcon() {
    return ApplicationImages.ICON_FOLDER_16;
  }

  /**
   * Cria um menu pop-up para este n.
   * 
   * @return um menu pop-up para este n.
   */
  @Override
  public JPopupMenu createPopupMenu() {
    JPopupMenu popupMenu = new JPopupMenu();
    popupMenu.add(new JMenuItem(new VersionWarningActionDecorator(
      new ImportDocumentationFile(getTree(), version))));
    popupMenu.add(new JMenuItem(new VersionWarningActionDecorator(new PasteFile(
      getTree(), LNG.get("algomanager.menu.doc.paste"),
      DocumentationFileNode.DATA_FLAVOR))));

    return popupMenu;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean canImport(Object[] data, DataFlavor flavor) {
    return null != data && 0 < data.length && DocumentationFileNode.DATA_FLAVOR
      .equals(flavor);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean importData(Object[] data) {
    DataTransferObject dto = (DataTransferObject) data[0];
    final AlgorithmVersionInfo sourceVersion = dto.getVersion();
    List<FileInfo> files = new ArrayList<>(data.length);
    for (Object obj : data) {
      dto = (DataTransferObject) obj;
      FileInfo file = dto.getFile();
      files.add(file);
    }

    IPathFactory sourcePathFactory = new DocumentationPathFactory(
      sourceVersion);
    IPathFactory targetPathFactory = new DocumentationPathFactory(version);
    AlgorithmManagementProxy.copyFiles(sourceVersion, files, sourcePathFactory,
      version, null, targetPathFactory, false, getWindow());

    return true;
  }
}
