/*
 * $Id$
 */

package csbase.client.applications.commandsmonitor.dal.xml.elements;

import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import tecgraf.javautils.xml.ImprovedXMLListIterator;
import tecgraf.javautils.xml.XMLElement;
import tecgraf.javautils.xml.XMLElementInterface;
import csbase.client.applications.commandsmonitor.models.ColumnDTO;

/**
 * Elemento de conjunto de colunas.
 * 
 * @author Tecgraf
 */
public class ColumnsSetElement extends XMLElement {

  /**
   * Consulta o nome da tag
   * 
   * @return tag
   */
  public static final String getTagName() {
    return "columns";
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void endTag(List<XMLElementInterface> childrenList) {

    Set<ColumnDTO> columnsInfo = new HashSet<ColumnDTO>();

    ImprovedXMLListIterator iterator =
      new ImprovedXMLListIterator(childrenList);
    while (iterator.hasNext()) {
      XMLElementInterface aColumnElement = iterator.next();
      ColumnDTO aColumnInfo = (ColumnDTO) aColumnElement.getAppObject();
      columnsInfo.add(aColumnInfo);
    }

    setAppObject(columnsInfo);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void write(Writer writer, String ident) throws IOException {
    throw new IllegalAccessError("Esse mtodo no deve ser utilizado.");
  }
}
