package csbase.client.applications.commandsmonitor.models;

import java.util.List;

/**
 * Informaes do painel de abas da aplicao.
 * 
 * @author Tecgraf / PUC-Rio
 */
public class TabbedPaneDTO {

  /** Identificador nico da aba inicialmente selecionada. */
  private final String selected;
  /** Lista ordenada de informaes das abas. */
  private final List<TablesTabDTO> tabsInfo;

  /**
   * Construtor. 
   * 
   * @param selected Identificador da aba inicialmente selecionada.
   * @param tabsInfo Lista ordenada de informaes das abas.
   */
  public TabbedPaneDTO(String selected, List<TablesTabDTO> tabsInfo) {
    this.selected = selected == null ? tabsInfo.get(0).getId() : selected;
    this.tabsInfo = tabsInfo;
  }

  /**
   * Obtm o identificador da aba inicialmente selecionada.
   * 
   * @return o identificador da aba inicialmente selecionada.
   */
  public String getSelectedTabId() {
    return selected;
  }

  /**
   * Obtm a lista ordenada de informaes das abas.
   * 
   * @return a lista ordenada de informaes das abas.
   */
  public List<TablesTabDTO> getTabsInfo() {
    return tabsInfo;
  }    
}
