package csbase.client.applications.flowapplication;

import static csbase.logic.algorithms.AlgorithmInfo.HIDE_ALGORITHM_PROPERTY;
import static csbase.logic.algorithms.AlgorithmInfo.HIDE_ALGORITHM_VALUE;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import javax.swing.Icon;

import csbase.client.applications.ApplicationImages;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.Category;
import tecgraf.javautils.gui.tree.DefaultNode;

/**
 * N Algoritmo.
 * 
 * @author Tecgraf/PUC-Rio.
 */
public final class CategoryTreeNode extends DefaultNode implements
  Comparable<CategoryTreeNode> {

  /**
   * O algoritmo.
   */
  private final Category category;

  /**
   * Cria o n.
   * 
   * @param category A categoria (No aceita {@code null}).
   * @param showVersions Indica se devem ser mostradas as verses dos algoritmos
   *        na rvore.
   */
  public CategoryTreeNode(final Category category, boolean showVersions) {
    super(category.getName());
    this.category = category;
    final List<CategoryTreeNode> categoryTreeNodes =
      new ArrayList<CategoryTreeNode>();
    for (final Category childCategory : category.getCategories()) {
      categoryTreeNodes.add(new CategoryTreeNode(childCategory, showVersions));
    }
    Collections.sort(categoryTreeNodes);
    final List<AlgorithmTreeNode> algorithmTreeNodes =
      new ArrayList<AlgorithmTreeNode>();
    for (final AlgorithmInfo algorithm : category.getAlgorithms()) {
      if (!HIDE_ALGORITHM_VALUE.equals(algorithm.getPropertyValue(
        HIDE_ALGORITHM_PROPERTY))) {
        final AlgorithmTreeNode algorithmTreeNode = new AlgorithmTreeNode(
          algorithm, showVersions);
        algorithmTreeNodes.add(algorithmTreeNode);
      }
    }
    Collections.sort(algorithmTreeNodes);
    final List<DefaultNode> children = new LinkedList<DefaultNode>();
    children.addAll(categoryTreeNodes);
    children.addAll(algorithmTreeNodes);
    for (final DefaultNode child : children) {
      addChild(child);
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public int compareTo(final CategoryTreeNode node) {
    return getCategory().compareTo(node.getCategory());
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean equals(Object obj) {
    if (obj == null) {
      return false;
    }
    if (getClass() != obj.getClass()) {
      return false;
    }
    final CategoryTreeNode other = (CategoryTreeNode) obj;
    return getCategory().equals(other.getCategory());
  }

  /**
   * Obtm a categoria.
   * 
   * @return A categoria.
   */
  public Category getCategory() {
    return category;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Icon getIcon() {
    if (category.getId().equals(FlowApplication.FAVORITE_CATEGORY_ID)) {
      return ApplicationImages.ICON_FAVORITE_16;
    }
    if (category.getId().equals(FlowApplication.GLOBAL_RECENT_CATEGORY_ID)) {
      return ApplicationImages.ICON_RECENT_16;
    }
    if (category.getId().equals(FlowApplication.LOCAL_RECENT_CATEGORY_ID)) {
      return ApplicationImages.ICON_RECENT_16;
    }
    return ApplicationImages.ICON_FOLDER_16;
  }
}
