package csbase.client.applications.flowapplication.multiflow.tree;

import java.util.ArrayList;
import java.util.List;

import javax.swing.tree.DefaultMutableTreeNode;

import csbase.logic.algorithms.flows.FlowNode;
import csbase.logic.algorithms.flows.NodeParameter;

/**
 * N da rvore de seleo de parmetros que representa um parmetro.
 */
public class ParameterNode extends DefaultMutableTreeNode implements
  ParameterSelectionNode {

  /**
   * Construtor.
   * 
   * @param parameter o parmetro.
   * @param node algoritmo dono do parmetro.
   */
  public ParameterNode(NodeParameter parameter, FlowNode node) {
    super(new ParameterSelection(parameter, node), false);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ParameterSelection getUserObject() {
    return (ParameterSelection) super.getUserObject();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public List<ParameterSelection> getParameterSelection() {
    ParameterSelection parameterSelection = getUserObject();
    List<ParameterSelection> selection = new ArrayList<ParameterSelection>(1);
    selection.add(parameterSelection);
    return selection;
  }
}
