package csbase.client.applications.flowapplication.multiflow.tree;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

/**
 * rvore que apresenta o fluxo com seus ns e respectivos parmetros para
 * seleo.
 */
public class ParameterSelectionTree extends JTree implements
  TreeSelectionListener, MouseListener {

  /** Modelo de seleo dos checkboxes da rvore. */
  private ParameterSelectionModel checkBoxSelectionModel;

  /**
   * Construtor.
   * 
   * @param root o n raiz da rvore.
   */
  public ParameterSelectionTree(TreeNode root) {
    super(root);
    checkBoxSelectionModel = new ParameterSelectionModel(getModel());
    setCellRenderer(new ParameterSelectionCellRenderer(checkBoxSelectionModel));
    this.addMouseListener(this);
    checkBoxSelectionModel.addTreeSelectionListener(this);
  }

  /**
   * Obtm o modelo de seleo dos checkboxes da rvore.
   * 
   * @return flow o modelo de seleo.
   */
  public ParameterSelectionModel getParameterSelectionModel() {
    return checkBoxSelectionModel;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void valueChanged(TreeSelectionEvent e) {
    treeDidChange();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void mouseClicked(MouseEvent me) {
    TreePath path = getPathForLocation(me.getX(), me.getY());
    if (path == null) {
      return;
    }
    boolean selected = checkBoxSelectionModel.isPathSelected(path, true);

    try {
      if (selected) {
        checkBoxSelectionModel.removeSelectionPath(path);
      }
      else {
        checkBoxSelectionModel.addSelectionPath(path);
      }
    }
    finally {
      treeDidChange();
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void mousePressed(MouseEvent e) {
    // Ignora o evento.
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void mouseReleased(MouseEvent e) {
    // Ignora o evento.
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void mouseEntered(MouseEvent e) {
    // Ignora o evento.
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void mouseExited(MouseEvent e) {
    // Ignora o evento.
  }
}