package csbase.client.applications.projectsmanager.actions;

import java.util.List;

import javax.swing.ImageIcon;

import csbase.client.applications.ApplicationImages;
import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.actions.core.ProjectsManagerAction;
import csbase.client.applications.projectsmanager.dialogs.AdminMailDialog;
import csbase.client.applications.projectsmanager.models.ProjectsManagerData;

/**
 * Ao que abre dilogo para envio de emails referentes a projetos.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class OpenMailDialogAction extends ProjectsManagerAction {

  /**
   * Construtor
   * 
   * @param projectsManager A aplicao
   */
  public OpenMailDialogAction(ProjectsManager projectsManager) {
    super(projectsManager);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionDone() {
    ProjectsManager projectsManager = getProjectsManager();
    List<ProjectsManagerData> projectList =
      projectsManager.getSelectedProjects();
    if (projectList == null || projectList.size() == 0) {
      return;
    }

    final AdminMailDialog amd =
      new AdminMailDialog(projectsManager, projectList);
    amd.pack();
    //    amd.center();
    amd.setVisible(true);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ImageIcon getStandardImageIcon() {
    return ApplicationImages.ICON_SENDMAIL_16;
  }
}
