package csbase.client.util.gui;

import java.util.Vector;

import javax.swing.DefaultComboBoxModel;

/**
 * Modelo de lista filtrvel. A filtragem no  automtica, acontece cada vez
 * que chama o mtodo filter. Elementos novos so filtrados.
 *
 * @author Tecgraf/PUC-Rio
 */
public class FilterableComboModel extends DefaultComboBoxModel {

  /**
   * Classe que define o que o filtro precisa implementar
   *
   *
   * @author Tecgraf/PUC-Rio
   */
  static public abstract class Filter {

    /**
     * Aceita o objeto
     *
     * @param o Objeto
     * @return se aceita ou no
     */
    public abstract boolean accept(Object o);

    /**
     * Informa se o filtro est ativo
     *
     * @return Se o filtro est ativo
     */
    public abstract boolean isEnabled();
  }

  /** Lista completa no filtrada */
  Vector<Object> originalList;

  /** Filtro */
  Filter filter;

  /**
   * Contrutor recebe a lista de elementos e o filtro
   *
   * @param list Lista de elementos
   * @param filter O filtro
   */
  public FilterableComboModel(Vector<Object> list, Filter filter) {
    this.originalList = list;
    this.filter = filter;
    filter();
  }

  /** Comanda uma filtragem */
  public void filter() {
    Object selection = getSelectedItem();
    super.removeAllElements();
    if (filter.isEnabled()) {
      for (Object elem : originalList) {
        if (filter.accept(elem)) {
          super.addElement(elem);
        }
      }
    }
    else {
      for (Object elem : originalList) {
        super.addElement(elem);
      }
    }

    if (selection != null) {
      setSelectedItem(selection);
    }
  }

  /** {@inheritDoc} */
  @Override
  public void addElement(Object object) {
    originalList.addElement(object);
    if (filter.accept(object)) {
      super.addElement(object);
    }
  }

  /** {@inheritDoc} */
  @Override
  public void insertElementAt(Object object, int index) {
    Object obj = super.getElementAt(index);
    int originalListIndex = originalList.indexOf(obj, 0);
    originalList.insertElementAt(obj, originalListIndex);

  }

  /** {@inheritDoc} */
  @Override
  public void removeElement(Object object) {
    super.removeElement(object);
    originalList.remove(object);
  }

  /** {@inheritDoc} */
  @Override
  public void removeElementAt(int index) {
    Object object = super.getElementAt(index);
    if (object != null) {
      super.removeElementAt(index);
      originalList.remove(object);
    }
  }

}
