package csbase.client.util.table;

/**
 * Observador de Tabela: observa os eventos que ocorrem na tabela.
 * 
 * @param <R> O tipo do valor armazenado na linha.
 * 
 */
public interface TableListener<R> {
  /**
   * Este mtodo  chamado aps uma linha ter sido adicionada.
   * 
   * @param newRowValue O valor da linha. 
   */
  void rowWasAdded(R newRowValue);

  /**
   * Este mtodo  chamado aps uma linha ter sido removida.
   * 
   * @param rowIndex O ndice da linha removida.
   */
  void rowWasRemoved(int rowIndex);
  
  /**
   * Este mtodo quando ocorre mudana na seleo de linhas.
   */
//  void selectionWasChanged();
}
